/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.mongodb.MongoClient;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.mongo.MongoClientProvider;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import org.apache.commons.lang.StringUtils;

final class ApplicationInitUtils {
    private ApplicationInitUtils() {
    }

    static MongoClient initializeApplication(ConfigurationPropertiesHolder propertiesHolder) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((String)propertiesHolder.getTruststorePath()) && StringUtils.isNotEmpty((String)propertiesHolder.getTruststorePassword())) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)propertiesHolder.getTruststorePath(), (String)propertiesHolder.getTruststorePassword());
        }
        if (propertiesHolder.isSocksProxyEnabled()) {
            new SocksProxy(propertiesHolder.getSocksProxyHost(), propertiesHolder.getSocksProxyPort(), propertiesHolder.getSocksProxyUsername(), propertiesHolder.getSocksProxyPassword()).init();
        }
        return new MongoClientProvider(propertiesHolder.getMongoProperties()).createMongoClient();
    }
}

