/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import eu.europeana.corelib.web.socks.SocksProxy;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfigurationException;

final class ApplicationInitUtils {
    private ApplicationInitUtils() {
    }

    static MongoClient initializeApplication(ConfigurationPropertiesHolder propertiesHolder) throws TrustStoreConfigurationException {
        MongoClient mongoClient;
        if (StringUtils.isNotEmpty((String)propertiesHolder.getTruststorePath()) && StringUtils.isNotEmpty((String)propertiesHolder.getTruststorePassword())) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)propertiesHolder.getTruststorePath(), (String)propertiesHolder.getTruststorePassword());
        }
        if (propertiesHolder.isSocksProxyEnabled()) {
            new SocksProxy(propertiesHolder.getSocksProxyHost(), propertiesHolder.getSocksProxyPort(), propertiesHolder.getSocksProxyUsername(), propertiesHolder.getSocksProxyPassword()).init();
        }
        if (propertiesHolder.getMongoHosts().length != propertiesHolder.getMongoPorts().length && propertiesHolder.getMongoPorts().length != 1) {
            throw new IllegalArgumentException("Mongo hosts and ports are not properly configured.");
        }
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(propertiesHolder.getMongoHosts().length);
        for (int i = 0; i < propertiesHolder.getMongoHosts().length; ++i) {
            ServerAddress address = propertiesHolder.getMongoHosts().length == propertiesHolder.getMongoPorts().length ? new ServerAddress(propertiesHolder.getMongoHosts()[i], propertiesHolder.getMongoPorts()[i]) : new ServerAddress(propertiesHolder.getMongoHosts()[i], propertiesHolder.getMongoPorts()[0]);
            serverAddresses.add(address);
        }
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.sslEnabled(propertiesHolder.isMongoEnableSSL());
        if (StringUtils.isEmpty((String)propertiesHolder.getMongoDb()) || StringUtils.isEmpty((String)propertiesHolder.getMongoUsername()) || StringUtils.isEmpty((String)propertiesHolder.getMongoPassword())) {
            mongoClient = new MongoClient(serverAddresses, optionsBuilder.build());
        } else {
            MongoCredential mongoCredential = MongoCredential.createCredential((String)propertiesHolder.getMongoUsername(), (String)propertiesHolder.getMongoAuthenticationDb(), (char[])propertiesHolder.getMongoPassword().toCharArray());
            mongoClient = new MongoClient(serverAddresses, mongoCredential, optionsBuilder.build());
        }
        return mongoClient;
    }
}

