/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.common.DaoFieldNames;
import eu.europeana.metis.core.dataset.DatasetExecutionInformation;
import eu.europeana.metis.core.rest.ExecutionHistory;
import eu.europeana.metis.core.rest.PluginsWithDataAvailability;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.rest.VersionEvolution;
import eu.europeana.metis.core.rest.execution.overview.ExecutionAndDatasetView;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.ExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.core.workflow.plugins.MetisPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class OrchestratorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrchestratorController.class);
    private final OrchestratorService orchestratorService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public OrchestratorController(OrchestratorService orchestratorService, AuthenticationClient authenticationClient) {
        this.orchestratorService = orchestratorService;
        this.authenticationClient = authenticationClient;
    }

    @PostMapping(value={"/orchestrator/workflows/{datasetId}"}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void createWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") ExecutablePluginType enforcedPredecessorType, @RequestBody Workflow workflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.createWorkflow(metisUser, datasetId, workflow, enforcedPredecessorType);
    }

    @PutMapping(value={"/orchestrator/workflows/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void updateWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") ExecutablePluginType enforcedPredecessorType, @RequestBody Workflow workflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.updateWorkflow(metisUser, datasetId, workflow, enforcedPredecessorType);
    }

    @DeleteMapping(value={"/orchestrator/workflows/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.deleteWorkflow(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Workflow with datasetId '{}' deleted", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
    }

    @GetMapping(value={"/orchestrator/workflows/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Workflow getWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Workflow workflow = this.orchestratorService.getWorkflow(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Workflow with datasetId '{}' found", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return workflow;
    }

    @PostMapping(value={"/orchestrator/workflows/{datasetId}/execute"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public WorkflowExecution addWorkflowInQueueOfWorkflowExecutions(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") ExecutablePluginType enforcedPredecessorType, @RequestParam(value="priority", defaultValue="0") int priority) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        WorkflowExecution workflowExecution = this.orchestratorService.addWorkflowInQueueOfWorkflowExecutions(metisUser, datasetId, enforcedPredecessorType, priority);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution for datasetId '{}' added to queue", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return workflowExecution;
    }

    @DeleteMapping(value={"/orchestrator/workflows/executions/{executionId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void cancelWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="executionId") String executionId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.cancelWorkflowExecution(metisUser, executionId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution for executionId '{}' is cancelling", (Object)executionId.replaceAll("[\r\n]", ""));
        }
    }

    @GetMapping(value={"/orchestrator/workflows/executions/{executionId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public WorkflowExecution getWorkflowExecutionByExecutionId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="executionId") String executionId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        WorkflowExecution workflowExecution = this.orchestratorService.getWorkflowExecutionByExecutionId(metisUser, executionId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution with executionId '{}' {}found.", (Object)executionId.replaceAll("[\r\n]", ""), (Object)(workflowExecution == null ? "not " : ""));
        }
        return workflowExecution;
    }

    @GetMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}/allowed_plugin"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public MetisPlugin getLatestFinishedPluginWorkflowExecutionByDatasetIdIfPluginTypeAllowedForExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="pluginType") ExecutablePluginType pluginType, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") ExecutablePluginType enforcedPredecessorType) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ExecutablePlugin latestFinishedPluginWorkflowExecutionByDatasetId = this.orchestratorService.getLatestFinishedPluginByDatasetIdIfPluginTypeAllowedForExecution(metisUser, datasetId, pluginType, enforcedPredecessorType);
        if (latestFinishedPluginWorkflowExecutionByDatasetId == null) {
            LOGGER.info("PluginType allowed by default");
        } else {
            LOGGER.info("Latest Plugin WorkflowExecution with id '{}' found", (Object)latestFinishedPluginWorkflowExecutionByDatasetId.getId());
        }
        return latestFinishedPluginWorkflowExecutionByDatasetId;
    }

    @GetMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}/information"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public DatasetExecutionInformation getDatasetExecutionInformation(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug("Requesting dataset execution information for datasetId: {}", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getDatasetExecutionInformation(metisUser, datasetId);
    }

    @GetMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<WorkflowExecution> getAllWorkflowExecutionsByDatasetId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="workflowStatus", required=false) Set<WorkflowStatus> workflowStatuses, @RequestParam(value="orderField", required=false, defaultValue="ID") DaoFieldNames orderField, @RequestParam(value="ascending", required=false, defaultValue="true") boolean ascending, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper result = this.orchestratorService.getAllWorkflowExecutions(metisUser, datasetId, workflowStatuses, orderField, ascending, nextPage);
        OrchestratorController.logPaging((ResponseListWrapper)result, (int)nextPage);
        return result;
    }

    @GetMapping(value={"/orchestrator/workflows/executions"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<WorkflowExecution> getAllWorkflowExecutions(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowStatus", required=false) Set<WorkflowStatus> workflowStatuses, @RequestParam(value="orderField", required=false, defaultValue="ID") DaoFieldNames orderField, @RequestParam(value="ascending", required=false, defaultValue="true") boolean ascending, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper result = this.orchestratorService.getAllWorkflowExecutions(metisUser, null, workflowStatuses, orderField, ascending, nextPage);
        OrchestratorController.logPaging((ResponseListWrapper)result, (int)nextPage);
        return result;
    }

    @GetMapping(value={"/orchestrator/workflows/executions/overview"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<ExecutionAndDatasetView> getWorkflowExecutionsOverview(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="pluginStatus", required=false) Set<PluginStatus> pluginStatuses, @RequestParam(value="pluginType", required=false) Set<PluginType> pluginTypes, @RequestParam(value="fromDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date fromDate, @RequestParam(value="toDate", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) Date toDate, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage, @RequestParam(value="pageCount", required=false, defaultValue="1") int pageCount) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        if (pageCount < 1) {
            throw new BadContentException("pageCount cannot be zero or a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper result = this.orchestratorService.getWorkflowExecutionsOverview(metisUser, pluginStatuses, pluginTypes, fromDate, toDate, nextPage, pageCount);
        OrchestratorController.logPaging((ResponseListWrapper)result, (int)nextPage);
        return result;
    }

    private static void logPaging(ResponseListWrapper<?> responseListWrapper, int nextPage) {
        LOGGER.debug("Batch of: {} workflowExecutions returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
    }

    @GetMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}/history"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ExecutionHistory getDatasetExecutionHistory(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug("Requesting dataset execution history for datasetId: {}", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getDatasetExecutionHistory(metisUser, datasetId);
    }

    @GetMapping(value={"/orchestrator/workflows/executions/{executionId}/plugins/data-availability"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public PluginsWithDataAvailability getExecutablePluginsWithDataAvailability(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="executionId") String executionId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            String logSanitizedExecutionId = executionId.replaceAll("[\r\n]", "");
            LOGGER.debug("Requesting plugins with data availability for executionId: {}", (Object)logSanitizedExecutionId);
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getExecutablePluginsWithDataAvailability(metisUser, executionId);
    }

    @GetMapping(value={"/orchestrator/workflows/evolution/{workflowExecutionId}/{pluginType}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public VersionEvolution getRecordEvolutionForVersion(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="workflowExecutionId") String workflowExecutionId, @PathVariable(value="pluginType") PluginType pluginType) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getRecordEvolutionForVersion(metisUser, workflowExecutionId, pluginType);
    }
}

