/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.common.Country;
import eu.europeana.metis.core.common.Language;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.dataset.DatasetXslt;
import eu.europeana.metis.core.dataset.DatasetXsltStringWrapper;
import eu.europeana.metis.core.rest.DatasetController;
import eu.europeana.metis.core.rest.Record;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.service.DatasetService;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class DatasetController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatasetController.class);
    private final DatasetService datasetService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public DatasetController(DatasetService datasetService, AuthenticationClient authenticationClient) {
        this.datasetService = datasetService;
        this.authenticationClient = authenticationClient;
    }

    @PostMapping(value={"/datasets"}, consumes={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Dataset createDataset(@RequestHeader(value="Authorization") String authorization, @RequestBody Dataset dataset) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Dataset createdDataset = this.datasetService.createDataset(metisUser, dataset);
        LOGGER.info("Dataset with datasetId: {}, datasetName: {} and organizationId {} created", new Object[]{createdDataset.getDatasetId(), createdDataset.getDatasetName(), createdDataset.getOrganizationId()});
        return createdDataset;
    }

    @PutMapping(value={"/datasets"}, consumes={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDataset(@RequestHeader(value="Authorization") String authorization, @RequestBody DatasetXsltStringWrapper datasetXsltStringWrapper) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.datasetService.updateDataset(metisUser, datasetXsltStringWrapper.getDataset(), datasetXsltStringWrapper.getXslt());
        LOGGER.info("Dataset with datasetId {} updated", (Object)datasetXsltStringWrapper.getDataset().getDatasetId());
    }

    @DeleteMapping(value={"/datasets/{datasetId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDataset(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.datasetService.deleteDatasetByDatasetId(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Dataset with datasetId '{}' deleted", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
    }

    @GetMapping(value={"/datasets/{datasetId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Dataset getByDatasetId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Dataset storedDataset = this.datasetService.getDatasetByDatasetId(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Dataset with datasetId '{}' found", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return storedDataset;
    }

    @GetMapping(value={"/datasets/{datasetId}/xslt"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public DatasetXslt getDatasetXsltByDatasetId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        DatasetXslt datasetXslt = this.datasetService.getDatasetXsltByDatasetId(metisUser, datasetId);
        LOGGER.info("Dataset XSLT with datasetId '{}' and xsltId: '{}' found", (Object)datasetId, (Object)datasetXslt.getId());
        return datasetXslt;
    }

    @GetMapping(value={"/datasets/xslt/{xsltId}"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String getXsltByXsltId(@PathVariable(value="xsltId") String xsltId) throws GenericMetisException {
        DatasetXslt datasetXslt = this.datasetService.getDatasetXsltByXsltId(xsltId);
        LOGGER.info("XSLT with xsltId '{}' found", (Object)datasetXslt.getId());
        return datasetXslt.getXslt();
    }

    @PostMapping(value={"/datasets/xslt/default"}, consumes={"text/plain"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public DatasetXslt createDefaultXslt(@RequestHeader(value="Authorization") String authorization, @RequestBody String xsltString) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        DatasetXslt defaultDatasetXslt = this.datasetService.createDefaultXslt(metisUser, xsltString);
        LOGGER.info("New default xslt created with xsltId: {}", (Object)defaultDatasetXslt.getId());
        return defaultDatasetXslt;
    }

    @GetMapping(value={"/datasets/xslt/default"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public String getLatestDefaultXslt() throws GenericMetisException {
        DatasetXslt datasetXslt = this.datasetService.getLatestDefaultXslt();
        LOGGER.info("Default XSLT with xsltId '{}' found", (Object)datasetXslt.getId());
        return datasetXslt.getXslt();
    }

    @PostMapping(value={"/datasets/{datasetId}/xslt/transform"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Record> transformRecordsUsingLatestDatasetXslt(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody List<Record> records) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.datasetService.transformRecordsUsingLatestDatasetXslt(metisUser, datasetId, records);
    }

    @PostMapping(value={"/datasets/{datasetId}/xslt/transform/default"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<Record> transformRecordsUsingLatestDefaultXslt(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody List<Record> records) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.datasetService.transformRecordsUsingLatestDefaultXslt(metisUser, datasetId, records);
    }

    @GetMapping(value={"/datasets/dataset_name/{datasetName}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Dataset getByDatasetName(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetName") String datasetName) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Dataset dataset = this.datasetService.getDatasetByDatasetName(metisUser, datasetName);
        LOGGER.info("Dataset with datasetName '{}' found", (Object)dataset.getDatasetName());
        return dataset;
    }

    @GetMapping(value={"/datasets/provider/{provider}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<Dataset> getAllDatasetsByProvider(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="provider") String provider, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.datasetService.getAllDatasetsByProvider(metisUser, provider, nextPage), this.datasetService.getDatasetsPerRequestLimit(), nextPage);
        LOGGER.info("Batch of: {} datasets returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @GetMapping(value={"/datasets/intermediate_provider/{intermediateProvider}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<Dataset> getAllDatasetsByIntermediateProvider(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="intermediateProvider") String intermediateProvider, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.datasetService.getAllDatasetsByIntermediateProvider(metisUser, intermediateProvider, nextPage), this.datasetService.getDatasetsPerRequestLimit(), nextPage);
        LOGGER.info("Batch of: {} datasets returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @GetMapping(value={"/datasets/data_provider/{dataProvider}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<Dataset> getAllDatasetsByDataProvider(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="dataProvider") String dataProvider, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.datasetService.getAllDatasetsByDataProvider(metisUser, dataProvider, nextPage), this.datasetService.getDatasetsPerRequestLimit(), nextPage);
        LOGGER.info("Batch of: {} datasets returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @GetMapping(value={"/datasets/organization_id/{organizationId}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<Dataset> getAllDatasetsByOrganizationId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="organizationId") String organizationId, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.datasetService.getAllDatasetsByOrganizationId(metisUser, organizationId, nextPage), this.datasetService.getDatasetsPerRequestLimit(), nextPage);
        LOGGER.info("Batch of: {} datasets returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @GetMapping(value={"/datasets/organization_name/{organizationName}"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<Dataset> getAllDatasetsByOrganizationName(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="organizationName") String organizationName, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.datasetService.getAllDatasetsByOrganizationName(metisUser, organizationName, nextPage), this.datasetService.getDatasetsPerRequestLimit(), nextPage);
        LOGGER.info("Batch of: {} datasets returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @GetMapping(value={"/datasets/countries"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<CountryModel> getDatasetsCountries(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return Arrays.stream(Country.values()).map(CountryModel::new).collect(Collectors.toList());
    }

    @GetMapping(value={"/datasets/languages"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<LanguageModel> getDatasetsLanguages(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return Language.getLanguageListSortedByName().stream().map(LanguageModel::new).collect(Collectors.toList());
    }
}

