/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import eu.europeana.metis.core.workflow.ValidationProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:metis.properties"})
public class ConfigurationPropertiesHolder {
    @Value(value="${max.concurrent.threads}")
    private int maxConcurrentThreads;
    @Value(value="${dps.monitor.check.interval.in.secs}")
    private int dpsMonitorCheckIntervalInSecs;
    @Value(value="${dps.connect.timeout.in.millisecs}")
    private int dpsConnectTimeoutInMillisecs;
    @Value(value="${dps.read.timeout.in.millisecs}")
    private int dpsReadTimeoutInMillisecs;
    @Value(value="${failsafe.margin.of.inactivity.in.secs}")
    private int failsafeMarginOfInactivityInSecs;
    @Value(value="${periodic.failsafe.check.in.millisecs}")
    private int periodicFailsafeCheckInMillisecs;
    @Value(value="${periodic.scheduler.check.in.millisecs}")
    private int periodicSchedulerCheckInMillisecs;
    @Value(value="${polling.timeout.for.cleaning.completion.service.in.secs}")
    private int pollingTimeoutForCleaningCompletionServiceInSecs;
    @Value(value="${period.of.no.processed.records.change.in.minutes}")
    private int periodOfNoProcessedRecordsChangeInMinutes;
    @Value(value="${redis.host}")
    private String redisHost;
    @Value(value="${redis.port}")
    private int redisPort;
    @Value(value="${redis.password}")
    private String redisPassword;
    @Value(value="${redis.enableSSL}")
    private boolean redisEnableSSL;
    @Value(value="${redis.enable.custom.truststore}")
    private boolean redisEnableCustomTruststore;
    @Value(value="${redisson.lock.watchdog.timeout.in.secs}")
    private int redissonLockWatchdogTimeoutInSecs;
    @Value(value="${rabbitmq.host}")
    private String rabbitmqHost;
    @Value(value="${rabbitmq.port}")
    private int rabbitmqPort;
    @Value(value="${rabbitmq.username}")
    private String rabbitmqUsername;
    @Value(value="${rabbitmq.password}")
    private String rabbitmqPassword;
    @Value(value="${rabbitmq.virtual.host}")
    private String rabbitmqVirtualHost;
    @Value(value="${rabbitmq.queue.name}")
    private String rabbitmqQueueName;
    @Value(value="${rabbitmq.highest.priority}")
    private int rabbitmqHighestPriority;
    @Value(value="${rabbitmq.enableSSL}")
    private boolean rabbitmqEnableSSL;
    @Value(value="${metis.core.baseUrl}")
    private String metisCoreBaseUrl;
    @Value(value="${metis.use.alternative.indexing.environment}")
    private boolean metisUseAlternativeIndexingEnvironment;
    @Value(value="${metis.link.checking.default.sampling.size}")
    private int metisLinkCheckingDefaultSamplingSize;
    @Value(value="${solr.commit.period.in.mins}")
    private int solrCommitPeriodInMins;
    @Value(value="${socks.proxy.enabled}")
    private boolean socksProxyEnabled;
    @Value(value="${socks.proxy.host}")
    private String socksProxyHost;
    @Value(value="${socks.proxy.port}")
    private String socksProxyPort;
    @Value(value="${socks.proxy.username}")
    private String socksProxyUsername;
    @Value(value="${socks.proxy.password}")
    private String socksProxyPassword;
    @Value(value="${truststore.path}")
    private String truststorePath;
    @Value(value="${truststore.password}")
    private String truststorePassword;
    @Value(value="${mongo.hosts}")
    private String[] mongoHosts;
    @Value(value="${mongo.port}")
    private int[] mongoPorts;
    @Value(value="${mongo.username}")
    private String mongoUsername;
    @Value(value="${mongo.password}")
    private String mongoPassword;
    @Value(value="${mongo.authentication.db}")
    private String mongoAuthenticationDb;
    @Value(value="${mongo.db}")
    private String mongoDb;
    @Value(value="${mongo.enableSSL}")
    private boolean mongoEnableSSL;
    @Value(value="${validation.internal.schema.zip}")
    private String validationInternalSchemaZip;
    @Value(value="${validation.internal.schema.root}")
    private String validationInternalSchemaRoot;
    @Value(value="${validation.internal.schematron.root}")
    private String validationInternalSchematronRoot;
    @Value(value="${validation.external.schema.zip}")
    private String validationExternalSchemaZip;
    @Value(value="${validation.external.schema.root}")
    private String validationExternalSchemaRoot;
    @Value(value="${validation.external.schematron.root}")
    private String validationExternalSchematronRoot;
    @Value(value="${authentication.baseUrl}")
    private String authenticationBaseUrl;
    @Value(value="${allowed.cors.hosts}")
    private String[] allowedCorsHosts;
    @Value(value="${ecloud.baseUrl}")
    private String ecloudBaseUrl;
    @Value(value="${ecloud.dps.baseUrl}")
    private String ecloudDpsBaseUrl;
    @Value(value="${ecloud.provider}")
    private String ecloudProvider;
    @Value(value="${ecloud.username}")
    private String ecloudUsername;
    @Value(value="${ecloud.password}")
    private String ecloudPassword;

    public int getMaxConcurrentThreads() {
        return this.maxConcurrentThreads;
    }

    public int getDpsMonitorCheckIntervalInSecs() {
        return this.dpsMonitorCheckIntervalInSecs;
    }

    public int getDpsConnectTimeoutInMillisecs() {
        return this.dpsConnectTimeoutInMillisecs;
    }

    public int getDpsReadTimeoutInMillisecs() {
        return this.dpsReadTimeoutInMillisecs;
    }

    public int getFailsafeMarginOfInactivityInSecs() {
        return this.failsafeMarginOfInactivityInSecs;
    }

    public int getPeriodicFailsafeCheckInMillisecs() {
        return this.periodicFailsafeCheckInMillisecs;
    }

    public int getPeriodicSchedulerCheckInMillisecs() {
        return this.periodicSchedulerCheckInMillisecs;
    }

    public int getPollingTimeoutForCleaningCompletionServiceInSecs() {
        return this.pollingTimeoutForCleaningCompletionServiceInSecs;
    }

    public int getPeriodOfNoProcessedRecordsChangeInMinutes() {
        return this.periodOfNoProcessedRecordsChangeInMinutes;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    public boolean isRedisEnableSSL() {
        return this.redisEnableSSL;
    }

    public boolean isRedisEnableCustomTruststore() {
        return this.redisEnableCustomTruststore;
    }

    public int getRedissonLockWatchdogTimeoutInSecs() {
        return this.redissonLockWatchdogTimeoutInSecs;
    }

    public String getRabbitmqHost() {
        return this.rabbitmqHost;
    }

    public int getRabbitmqPort() {
        return this.rabbitmqPort;
    }

    public String getRabbitmqUsername() {
        return this.rabbitmqUsername;
    }

    public String getRabbitmqPassword() {
        return this.rabbitmqPassword;
    }

    public String getRabbitmqVirtualHost() {
        return this.rabbitmqVirtualHost;
    }

    public boolean isRabbitmqEnableSSL() {
        return this.rabbitmqEnableSSL;
    }

    public String getRabbitmqQueueName() {
        return this.rabbitmqQueueName;
    }

    public int getRabbitmqHighestPriority() {
        return this.rabbitmqHighestPriority;
    }

    public String getMetisCoreBaseUrl() {
        return this.metisCoreBaseUrl;
    }

    public boolean getMetisUseAlternativeIndexingEnvironment() {
        return this.metisUseAlternativeIndexingEnvironment;
    }

    public int getMetisLinkCheckingDefaultSamplingSize() {
        return this.metisLinkCheckingDefaultSamplingSize;
    }

    public int getSolrCommitPeriodInMins() {
        return this.solrCommitPeriodInMins;
    }

    public boolean isSocksProxyEnabled() {
        return this.socksProxyEnabled;
    }

    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String[] getMongoHosts() {
        return this.mongoHosts == null ? null : (String[])this.mongoHosts.clone();
    }

    public int[] getMongoPorts() {
        return this.mongoPorts == null ? null : (int[])this.mongoPorts.clone();
    }

    public String getMongoUsername() {
        return this.mongoUsername;
    }

    public String getMongoPassword() {
        return this.mongoPassword;
    }

    public String getMongoAuthenticationDb() {
        return this.mongoAuthenticationDb;
    }

    public String getMongoDb() {
        return this.mongoDb;
    }

    public boolean isMongoEnableSSL() {
        return this.mongoEnableSSL;
    }

    public String getAuthenticationBaseUrl() {
        return this.authenticationBaseUrl;
    }

    public String[] getAllowedCorsHosts() {
        return this.allowedCorsHosts == null ? null : (String[])this.allowedCorsHosts.clone();
    }

    public String getEcloudBaseUrl() {
        return this.ecloudBaseUrl;
    }

    public String getEcloudDpsBaseUrl() {
        return this.ecloudDpsBaseUrl;
    }

    public String getEcloudProvider() {
        return this.ecloudProvider;
    }

    public String getEcloudUsername() {
        return this.ecloudUsername;
    }

    public String getEcloudPassword() {
        return this.ecloudPassword;
    }

    public ValidationProperties getValidationExternalProperties() {
        return new ValidationProperties(this.validationExternalSchemaZip, this.validationExternalSchemaRoot, this.validationExternalSchematronRoot);
    }

    public ValidationProperties getValidationInternalProperties() {
        return new ValidationProperties(this.validationInternalSchemaZip, this.validationInternalSchemaRoot, this.validationInternalSchematronRoot);
    }
}

