/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.service.ScheduleWorkflowService;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class ScheduleWorkflowController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleWorkflowController.class);
    private final ScheduleWorkflowService scheduleWorkflowService;
    private final AuthenticationClient authenticationClient;

    public ScheduleWorkflowController(ScheduleWorkflowService scheduleWorkflowService, AuthenticationClient authenticationClient) {
        this.scheduleWorkflowService = scheduleWorkflowService;
        this.authenticationClient = authenticationClient;
    }

    @RequestMapping(value={"/orchestrator/workflows/schedule"}, method={RequestMethod.POST}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void scheduleWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @RequestBody ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.scheduleWorkflow(metisUser, scheduledWorkflow);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflowExecution for datasetId '{}', pointerDate at '{}', scheduled '{}'", new Object[]{scheduledWorkflow.getDatasetId(), scheduledWorkflow.getPointerDate(), scheduledWorkflow.getScheduleFrequence().name()});
        }
    }

    @RequestMapping(value={"/orchestrator/workflows/schedule/{datasetId}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ScheduledWorkflow getScheduledWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ScheduledWorkflow scheduledWorkflow = this.scheduleWorkflowService.getScheduledWorkflowByDatasetId(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflow with with datasetId '{}' found", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return scheduledWorkflow;
    }

    @RequestMapping(value={"/orchestrator/workflows/schedule"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<ScheduledWorkflow> getAllScheduledWorkflows(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.scheduleWorkflowService.getAllScheduledWorkflows(metisUser, ScheduleFrequence.NULL, nextPage), this.scheduleWorkflowService.getScheduledWorkflowsPerRequest(), nextPage);
        LOGGER.info("Batch of: {} scheduledWorkflows returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @RequestMapping(value={"/orchestrator/workflows/schedule"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void updateScheduledWorkflow(@RequestHeader(value="Authorization") String authorization, @RequestBody ScheduledWorkflow scheduledWorkflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.updateScheduledWorkflow(metisUser, scheduledWorkflow);
        LOGGER.info("ScheduledWorkflow with with datasetId '{}' updated", (Object)scheduledWorkflow.getDatasetId());
    }

    @RequestMapping(value={"/orchestrator/workflows/schedule/{datasetId}"}, method={RequestMethod.DELETE}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void deleteScheduledWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.scheduleWorkflowService.deleteScheduledWorkflow(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("ScheduledWorkflowExecution for datasetId '{}' deleted", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
    }
}

