/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.dataset.DatasetExecutionInformation;
import eu.europeana.metis.core.execution.ExecutionRules;
import eu.europeana.metis.core.rest.ResponseListWrapper;
import eu.europeana.metis.core.rest.VersionEvolution;
import eu.europeana.metis.core.service.OrchestratorService;
import eu.europeana.metis.core.workflow.OrderField;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class OrchestratorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrchestratorController.class);
    private final OrchestratorService orchestratorService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public OrchestratorController(OrchestratorService orchestratorService, AuthenticationClient authenticationClient) {
        this.orchestratorService = orchestratorService;
        this.authenticationClient = authenticationClient;
    }

    @RequestMapping(value={"/orchestrator/workflows/{datasetId}"}, method={RequestMethod.POST}, consumes={"application/json", "application/xml"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public void createWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody Workflow workflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.createWorkflow(metisUser, datasetId, workflow);
    }

    @RequestMapping(value={"/orchestrator/workflows/{datasetId}"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void updateWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestBody Workflow workflow) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.updateWorkflow(metisUser, datasetId, workflow);
    }

    @RequestMapping(value={"/orchestrator/workflows/{datasetId}"}, method={RequestMethod.DELETE}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.deleteWorkflow(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Workflow with datasetId '{}' deleted", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
    }

    @RequestMapping(value={"/orchestrator/workflows/{datasetId}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Workflow getWorkflow(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        Workflow workflow = this.orchestratorService.getWorkflow(metisUser, datasetId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Workflow with datasetId '{}' found", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return workflow;
    }

    @RequestMapping(value={"/orchestrator/workflows/{datasetId}/execute"}, method={RequestMethod.POST}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public WorkflowExecution addWorkflowInQueueOfWorkflowExecutions(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") PluginType enforcedPluginType, @RequestParam(value="priority", defaultValue="0") int priority) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        WorkflowExecution workflowExecution = this.orchestratorService.addWorkflowInQueueOfWorkflowExecutions(metisUser, datasetId, enforcedPluginType, priority);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution for datasetId '{}' added to queue", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        return workflowExecution;
    }

    @RequestMapping(value={"/orchestrator/workflows/executions/{executionId}"}, method={RequestMethod.DELETE}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void cancelWorkflowExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="executionId") String executionId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        this.orchestratorService.cancelWorkflowExecution(metisUser, executionId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution for executionId '{}' is cancelling", (Object)executionId.replaceAll("[\r\n]", ""));
        }
    }

    @RequestMapping(value={"/orchestrator/workflows/executions/{executionId}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public WorkflowExecution getWorkflowExecutionByExecutionId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="executionId") String executionId) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        WorkflowExecution workflowExecution = this.orchestratorService.getWorkflowExecutionByExecutionId(metisUser, executionId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("WorkflowExecution with executionId '{}' found", (Object)executionId.replaceAll("[\r\n]", ""));
        }
        return workflowExecution;
    }

    @RequestMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}/allowed_plugin"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public AbstractMetisPlugin getLatestFinishedPluginWorkflowExecutionByDatasetIdIfPluginTypeAllowedForExecution(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="pluginType") PluginType pluginType, @RequestParam(value="enforcedPluginType", required=false, defaultValue="") PluginType enforcedPluginType) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        AbstractMetisPlugin latestFinishedPluginWorkflowExecutionByDatasetId = this.orchestratorService.getLatestFinishedPluginByDatasetIdIfPluginTypeAllowedForExecution(metisUser, datasetId, pluginType, enforcedPluginType);
        if (latestFinishedPluginWorkflowExecutionByDatasetId == null) {
            if (ExecutionRules.getHarvestPluginGroup().contains(pluginType)) {
                LOGGER.info("PluginType allowed by default");
            }
        } else {
            LOGGER.info("Latest Plugin WorkflowExecution with id '{}' found", (Object)latestFinishedPluginWorkflowExecutionByDatasetId.getId());
        }
        return latestFinishedPluginWorkflowExecutionByDatasetId;
    }

    @RequestMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}/information"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public DatasetExecutionInformation getDatasetExecutionInformation(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug("Requesting dataset execution information for datasetId: {}", (Object)datasetId.replaceAll("[\r\n]", ""));
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getDatasetExecutionInformation(metisUser, datasetId);
    }

    @RequestMapping(value={"/orchestrator/workflows/executions/dataset/{datasetId}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<WorkflowExecution> getAllWorkflowExecutionsByDatasetId(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="datasetId") String datasetId, @RequestParam(value="workflowStatus", required=false) Set<WorkflowStatus> workflowStatuses, @RequestParam(value="orderField", required=false, defaultValue="ID") OrderField orderField, @RequestParam(value="ascending", required=false, defaultValue="true") boolean ascending, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.orchestratorService.getAllWorkflowExecutions(metisUser, datasetId, workflowStatuses, orderField, ascending, nextPage), this.orchestratorService.getWorkflowExecutionsPerRequest(), nextPage);
        LOGGER.debug("Batch of: {} workflowExecutions returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @RequestMapping(value={"/orchestrator/workflows/executions"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseListWrapper<WorkflowExecution> getAllWorkflowExecutions(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowStatus", required=false) Set<WorkflowStatus> workflowStatuses, @RequestParam(value="orderField", required=false, defaultValue="ID") OrderField orderField, @RequestParam(value="ascending", required=false, defaultValue="true") boolean ascending, @RequestParam(value="nextPage", required=false, defaultValue="0") int nextPage) throws GenericMetisException {
        if (nextPage < 0) {
            throw new BadContentException("nextPage cannot be a negative number");
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        ResponseListWrapper responseListWrapper = new ResponseListWrapper();
        responseListWrapper.setResultsAndLastPage(this.orchestratorService.getAllWorkflowExecutions(metisUser, null, workflowStatuses, orderField, ascending, nextPage), this.orchestratorService.getWorkflowExecutionsPerRequest(), nextPage);
        LOGGER.debug("Batch of: {} workflowExecutions returned, using batch nextPage: {}", (Object)responseListWrapper.getListSize(), (Object)nextPage);
        return responseListWrapper;
    }

    @RequestMapping(value={"/orchestrator/workflows/evolution/{workflowExecutionId}/{pluginType}"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public VersionEvolution getRecordEvolutionForVersion(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="workflowExecutionId") String workflowExecutionId, @PathVariable(value="pluginType") PluginType pluginType) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.orchestratorService.getRecordEvolutionForVersion(metisUser, workflowExecutionId, pluginType);
    }
}

