/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.config;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.FileServiceClient;
import eu.europeana.cloud.mcs.driver.RecordServiceClient;
import eu.europeana.metis.core.rest.config.ConfigurationPropertiesHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.core.rest"})
public class ECloudConfig
implements WebMvcConfigurer {
    private final ConfigurationPropertiesHolder propertiesHolder;

    @Autowired
    public ECloudConfig(ConfigurationPropertiesHolder propertiesHolder) {
        this.propertiesHolder = propertiesHolder;
    }

    @Bean
    DataSetServiceClient dataSetServiceClient() {
        return new DataSetServiceClient(this.propertiesHolder.getEcloudBaseUrl(), this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
    }

    @Bean
    RecordServiceClient recordServiceClient() {
        return new RecordServiceClient(this.propertiesHolder.getEcloudBaseUrl(), this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
    }

    @Bean
    FileServiceClient fileServiceClient() {
        return new FileServiceClient(this.propertiesHolder.getEcloudBaseUrl(), this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
    }

    @Bean
    DpsClient dpsClient() {
        return new DpsClient(this.propertiesHolder.getEcloudDpsBaseUrl(), this.propertiesHolder.getEcloudUsername(), this.propertiesHolder.getEcloudPassword(), this.propertiesHolder.getDpsConnectTimeoutInMillisecs(), this.propertiesHolder.getDpsReadTimeoutInMillisecs());
    }
}

