/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.metis.authentication.rest.client.AuthenticationClient;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.core.rest.RecordsResponse;
import eu.europeana.metis.core.service.ProxiesService;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.exception.GenericMetisException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class ProxiesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxiesController.class);
    private static final int NUMBER_OF_RECORDS = 5;
    private final ProxiesService proxiesService;
    private final AuthenticationClient authenticationClient;

    @Autowired
    public ProxiesController(ProxiesService proxiesService, AuthenticationClient authenticationClient) {
        this.proxiesService = proxiesService;
        this.authenticationClient = authenticationClient;
    }

    @RequestMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/logs"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<SubTaskInfo> getExternalTaskLogs(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId, @RequestParam(value="from") int from, @RequestParam(value="to") int to) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task logs for topologyName: {}, externalTaskId: {}, from: {}, to: {}", new Object[]{topologyName.replaceAll("[\r\n]", ""), externalTaskId, from, to});
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskLogs(metisUser, topologyName, externalTaskId, from, to);
    }

    @RequestMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/report"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public TaskErrorsInfo getExternalTaskReport(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId, @RequestParam(value="idsPerError") int idsPerError) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task reports for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n]", ""), (Object)externalTaskId);
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskReport(metisUser, topologyName, externalTaskId, idsPerError);
    }

    @RequestMapping(value={"/orchestrator/proxies/{topologyName}/task/{externalTaskId}/statistics"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public StatisticsReport getExternalTaskStatistics(@RequestHeader(value="Authorization") String authorization, @PathVariable(value="topologyName") String topologyName, @PathVariable(value="externalTaskId") long externalTaskId) throws GenericMetisException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting proxy call task statistics for topologyName: {}, externalTaskId: {}", (Object)topologyName.replaceAll("[\r\n]", ""), (Object)externalTaskId);
        }
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getExternalTaskStatistics(metisUser, topologyName, externalTaskId);
    }

    @RequestMapping(value={"/orchestrator/proxies/records"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public RecordsResponse getListOfFileContentsFromPluginExecution(@RequestHeader(value="Authorization") String authorization, @RequestParam(value="workflowExecutionId") String workflowExecutionId, @RequestParam(value="pluginType") PluginType pluginType, @RequestParam(value="nextPage", required=false) String nextPage) throws GenericMetisException {
        MetisUser metisUser = this.authenticationClient.getUserByAccessTokenInHeader(authorization);
        return this.proxiesService.getListOfFileContentsFromPluginExecution(metisUser, workflowExecutionId, pluginType, StringUtils.isEmpty((CharSequence)nextPage) ? null : nextPage, 5);
    }
}

