/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dataset;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexes;
import eu.europeana.metis.core.common.Country;
import eu.europeana.metis.core.common.CountryDeserializer;
import eu.europeana.metis.core.common.CountrySerializer;
import eu.europeana.metis.core.common.Language;
import eu.europeana.metis.core.common.LanguageDeserializer;
import eu.europeana.metis.core.common.LanguageSerializer;
import eu.europeana.metis.json.ObjectIdSerializer;
import eu.europeana.metis.mongo.HasMongoObjectId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.types.ObjectId;

@Entity
@Indexes(value={@Index(fields={@Field(value="organizationId"), @Field(value="datasetName")}, options=@IndexOptions(unique=true)), @Index(fields={@Field(value="ecloudDatasetId")}, options=@IndexOptions(unique=true)), @Index(fields={@Field(value="datasetId")}), @Index(fields={@Field(value="datasetName")}), @Index(fields={@Field(value="organizationId")}), @Index(fields={@Field(value="organizationName")}), @Index(fields={@Field(value="provider")}), @Index(fields={@Field(value="intermediateProvider")}), @Index(fields={@Field(value="dataProvider")}), @Index(fields={@Field(value="createdByUserId")})})
public class Dataset
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    private String ecloudDatasetId;
    private String datasetId;
    private String datasetName;
    private String organizationId;
    private String organizationName;
    private String provider;
    private String intermediateProvider;
    private String dataProvider;
    private String createdByUserId;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date createdDate;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    private List<String> datasetIdsToRedirectFrom = new ArrayList<String>();
    private String replacedBy;
    private String replaces;
    @JsonSerialize(using=CountrySerializer.class)
    @JsonDeserialize(using=CountryDeserializer.class)
    private Country country;
    @JsonSerialize(using=LanguageSerializer.class)
    @JsonDeserialize(using=LanguageDeserializer.class)
    private Language language;
    private String description;
    private Boolean unfitForPublication;
    private String notes;
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId xsltId;

    public ObjectId getId() {
        return this.id;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getEcloudDatasetId() {
        return this.ecloudDatasetId;
    }

    public void setEcloudDatasetId(String ecloudDatasetId) {
        this.ecloudDatasetId = ecloudDatasetId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getIntermediateProvider() {
        return this.intermediateProvider;
    }

    public void setIntermediateProvider(String intermediateProvider) {
        this.intermediateProvider = intermediateProvider;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(String dataProvider) {
        this.dataProvider = dataProvider;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = new Date(createdDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public List<String> getDatasetIdsToRedirectFrom() {
        return new ArrayList<String>(this.datasetIdsToRedirectFrom);
    }

    public void setDatasetIdsToRedirectFrom(List<String> datasetIdsToRedirectFrom) {
        this.datasetIdsToRedirectFrom = datasetIdsToRedirectFrom == null ? new ArrayList<String>() : new ArrayList<String>(datasetIdsToRedirectFrom);
    }

    public String getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(String replacedBy) {
        this.replacedBy = replacedBy;
    }

    public String getReplaces() {
        return this.replaces;
    }

    public void setReplaces(String replaces) {
        this.replaces = replaces;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getUnfitForPublication() {
        return this.unfitForPublication;
    }

    public void setUnfitForPublication(Boolean unfitForPublication) {
        this.unfitForPublication = unfitForPublication;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ObjectId getXsltId() {
        return this.xsltId;
    }

    public void setXsltId(ObjectId xsltId) {
        this.xsltId = xsltId;
    }
}

