/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.EcloudBasePluginParameters;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.Topology;
import java.util.HashMap;

public class HTTPHarvestPlugin
extends AbstractExecutablePlugin<HTTPHarvestPluginMetadata> {
    private final String topologyName = Topology.HTTP_HARVEST.getTopologyName();

    HTTPHarvestPlugin() {
        super(PluginType.HTTP_HARVEST);
    }

    HTTPHarvestPlugin(HTTPHarvestPluginMetadata pluginMetadata) {
        super(PluginType.HTTP_HARVEST, pluginMetadata);
    }

    @Override
    public String getTopologyName() {
        return this.topologyName;
    }

    @Override
    DpsTask prepareDpsTask(String datasetId, EcloudBasePluginParameters ecloudBasePluginParameters) {
        String targetUrl = ((HTTPHarvestPluginMetadata)this.getPluginMetadata()).getUrl();
        boolean useDefaultIdentifiers = ((HTTPHarvestPluginMetadata)this.getPluginMetadata()).isUseDefaultIdentifiers();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("METIS_DATASET_ID", datasetId);
        parameters.put("USE_DEFAULT_IDENTIFIERS", String.valueOf(useDefaultIdentifiers));
        return this.createDpsTaskForHarvestPlugin(ecloudBasePluginParameters, parameters, targetUrl);
    }
}

