/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.DataStatus;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPlugin;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginType;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPlugin;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPlugin;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.MetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.NormalizationPlugin;
import eu.europeana.metis.core.workflow.plugins.NormalizationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.TransformationPlugin;
import eu.europeana.metis.core.workflow.plugins.TransformationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPluginMetadata;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import org.bson.types.ObjectId;

public final class ExecutablePluginFactory {
    private static final Map<ExecutablePluginType, PluginCreator<?>> pluginCreators;

    private ExecutablePluginFactory() {
    }

    public static AbstractExecutablePlugin createPlugin(ExecutablePluginMetadata metadata) {
        PluginCreator<?> creator = pluginCreators.get((Object)metadata.getExecutablePluginType());
        if (creator == null) {
            throw new IllegalStateException("Found unknown executable plugin type: " + (Object)((Object)metadata.getExecutablePluginType()));
        }
        AbstractExecutablePlugin<?> plugin = creator.createPlugin(metadata);
        plugin.setId(new ObjectId().toString() + "-" + plugin.getPluginType().name());
        plugin.setDataStatus(DataStatus.NOT_YET_GENERATED);
        return plugin;
    }

    static {
        EnumMap<ExecutablePluginType, PluginCreator<AbstractExecutablePluginMetadata>> creators = new EnumMap<ExecutablePluginType, PluginCreator<AbstractExecutablePluginMetadata>>(ExecutablePluginType.class);
        creators.put(ExecutablePluginType.HTTP_HARVEST, new PluginCreator<HTTPHarvestPluginMetadata>(HTTPHarvestPluginMetadata.class, HTTPHarvestPlugin::new));
        creators.put(ExecutablePluginType.OAIPMH_HARVEST, new PluginCreator<OaipmhHarvestPluginMetadata>(OaipmhHarvestPluginMetadata.class, OaipmhHarvestPlugin::new));
        creators.put(ExecutablePluginType.ENRICHMENT, new PluginCreator<EnrichmentPluginMetadata>(EnrichmentPluginMetadata.class, EnrichmentPlugin::new));
        creators.put(ExecutablePluginType.MEDIA_PROCESS, new PluginCreator<MediaProcessPluginMetadata>(MediaProcessPluginMetadata.class, MediaProcessPlugin::new));
        creators.put(ExecutablePluginType.LINK_CHECKING, new PluginCreator<LinkCheckingPluginMetadata>(LinkCheckingPluginMetadata.class, LinkCheckingPlugin::new));
        creators.put(ExecutablePluginType.VALIDATION_EXTERNAL, new PluginCreator<ValidationExternalPluginMetadata>(ValidationExternalPluginMetadata.class, ValidationExternalPlugin::new));
        creators.put(ExecutablePluginType.TRANSFORMATION, new PluginCreator<TransformationPluginMetadata>(TransformationPluginMetadata.class, TransformationPlugin::new));
        creators.put(ExecutablePluginType.VALIDATION_INTERNAL, new PluginCreator<ValidationInternalPluginMetadata>(ValidationInternalPluginMetadata.class, ValidationInternalPlugin::new));
        creators.put(ExecutablePluginType.NORMALIZATION, new PluginCreator<NormalizationPluginMetadata>(NormalizationPluginMetadata.class, NormalizationPlugin::new));
        creators.put(ExecutablePluginType.PREVIEW, new PluginCreator<IndexToPreviewPluginMetadata>(IndexToPreviewPluginMetadata.class, IndexToPreviewPlugin::new));
        creators.put(ExecutablePluginType.PUBLISH, new PluginCreator<IndexToPublishPluginMetadata>(IndexToPublishPluginMetadata.class, IndexToPublishPlugin::new));
        pluginCreators = Collections.unmodifiableMap(creators);
    }

    private static class PluginCreator<M extends AbstractExecutablePluginMetadata> {
        private Class<M> pluginMetadataType;
        private Function<M, AbstractExecutablePlugin<M>> pluginCreatorFunction;

        PluginCreator(Class<M> pluginMetadataType, Function<M, AbstractExecutablePlugin<M>> pluginCreatorFunction) {
            this.pluginMetadataType = pluginMetadataType;
            this.pluginCreatorFunction = pluginCreatorFunction;
        }

        AbstractExecutablePlugin<M> createPlugin(MetisPluginMetadata pluginMetadata) {
            AbstractExecutablePluginMetadata castPluginMetadata = (AbstractExecutablePluginMetadata)this.pluginMetadataType.cast(pluginMetadata);
            return this.pluginCreatorFunction.apply(castPluginMetadata);
        }
    }
}

