/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.workflow.HasMongoObjectId;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.json.ObjectIdSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bson.types.ObjectId;

@Entity
@Indexes(value={@Index(fields={@Field(value="datasetId")})})
public class WorkflowExecution
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    private String datasetId;
    @Indexed
    private WorkflowStatus workflowStatus;
    @Indexed
    private String ecloudDatasetId;
    @Indexed
    private String cancelledBy;
    private int workflowPriority;
    private boolean cancelling;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date createdDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date startedDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date finishedDate;
    private List<AbstractMetisPlugin> metisPlugins = new ArrayList<AbstractMetisPlugin>();

    public WorkflowExecution() {
    }

    public WorkflowExecution(Dataset dataset, List<? extends AbstractMetisPlugin> metisPlugins, int workflowPriority) {
        this.datasetId = dataset.getDatasetId();
        this.ecloudDatasetId = dataset.getEcloudDatasetId();
        this.workflowPriority = workflowPriority;
        this.metisPlugins = new ArrayList<AbstractMetisPlugin>(metisPlugins);
    }

    public void setWorkflowAndAllQualifiedPluginsToCancelled() {
        this.setWorkflowStatus(WorkflowStatus.CANCELLED);
        this.setAllQualifiedPluginsToCancelled();
        this.setCancelling(false);
    }

    public void checkAndSetAllRunningAndInqueuePluginsToCancelledIfOnePluginHasFailed() {
        boolean hasAPluginFailed = false;
        for (AbstractMetisPlugin metisPlugin : this.getMetisPlugins()) {
            if (metisPlugin.getPluginStatus() != PluginStatus.FAILED) continue;
            hasAPluginFailed = true;
            break;
        }
        if (hasAPluginFailed) {
            this.setWorkflowStatus(WorkflowStatus.FAILED);
            this.setAllQualifiedPluginsToCancelled();
        }
    }

    private void setAllQualifiedPluginsToCancelled() {
        for (AbstractMetisPlugin metisPlugin : this.getMetisPlugins()) {
            if (metisPlugin.getPluginStatus() != PluginStatus.INQUEUE && metisPlugin.getPluginStatus() != PluginStatus.RUNNING && metisPlugin.getPluginStatus() != PluginStatus.CLEANING && metisPlugin.getPluginStatus() != PluginStatus.PENDING) continue;
            metisPlugin.setPluginStatusAndResetFailMessage(PluginStatus.CANCELLED);
        }
    }

    public Optional<AbstractMetisPlugin> getMetisPluginWithType(PluginType pluginType) {
        return this.getMetisPlugins().stream().filter(plugin -> plugin.getPluginType() == pluginType).findFirst();
    }

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public void setId(ObjectId id) {
        this.id = id;
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public void setCancelling(boolean cancelling) {
        this.cancelling = cancelling;
    }

    public WorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    public void setWorkflowStatus(WorkflowStatus workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getCancelledBy() {
        return this.cancelledBy;
    }

    public void setCancelledBy(String cancelledBy) {
        this.cancelledBy = cancelledBy;
    }

    public String getEcloudDatasetId() {
        return this.ecloudDatasetId;
    }

    public void setEcloudDatasetId(String ecloudDatasetId) {
        this.ecloudDatasetId = ecloudDatasetId;
    }

    public int getWorkflowPriority() {
        return this.workflowPriority;
    }

    public void setWorkflowPriority(int workflowPriority) {
        this.workflowPriority = workflowPriority;
    }

    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate == null ? null : new Date(createdDate.getTime());
    }

    public Date getStartedDate() {
        return this.startedDate == null ? null : new Date(this.startedDate.getTime());
    }

    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate == null ? null : new Date(startedDate.getTime());
    }

    public Date getFinishedDate() {
        return this.finishedDate == null ? null : new Date(this.finishedDate.getTime());
    }

    public void setFinishedDate(Date finishedDate) {
        this.finishedDate = finishedDate == null ? null : new Date(finishedDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public List<AbstractMetisPlugin> getMetisPlugins() {
        return this.metisPlugins;
    }

    public void setMetisPlugins(List<AbstractMetisPlugin> metisPlugins) {
        this.metisPlugins = metisPlugins;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.datasetId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WorkflowExecution that = (WorkflowExecution)obj;
        return Objects.equals(this.id, that.getId()) && Objects.equals(this.datasetId, that.datasetId);
    }
}

