/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ResponseListWrapper<T> {
    @JacksonXmlElementWrapper(localName="Results")
    @JacksonXmlProperty(localName="Result")
    private List<T> results;
    private int listSize;
    private int nextPage;
    private Boolean maxResultCountReached;

    public void setResultsAndLastPage(List<T> results, int resultsPerRequestLimit, int nextPage) {
        this.setResultsAndLastPage(results, resultsPerRequestLimit, nextPage, null);
    }

    public void setResultsAndLastPage(List<T> results, int resultsPerRequestLimit, int nextPage, Boolean maxResultCountReached) {
        this.setResultsAndLastPage(results, resultsPerRequestLimit, nextPage, 1, maxResultCountReached);
    }

    public void setResultsAndLastPage(List<T> results, int resultsPerRequestLimit, int nextPage, int pageCount) {
        this.setResultsAndLastPage(results, resultsPerRequestLimit, nextPage, pageCount, null);
    }

    public void setResultsAndLastPage(List<T> results, int resultsPerRequestLimit, int nextPage, int pageCount, Boolean maxResultCountReached) {
        this.nextPage = results == null || results.isEmpty() || Boolean.TRUE.equals(maxResultCountReached) ? -1 : (results.size() < resultsPerRequestLimit * pageCount ? -1 : nextPage + pageCount);
        this.listSize = Optional.ofNullable(results).map(List::size).orElse(0);
        this.maxResultCountReached = maxResultCountReached;
        this.setResults(results);
    }

    public void clear() {
        if (this.results != null) {
            this.results.clear();
        }
        this.listSize = 0;
        this.nextPage = 0;
    }

    public List<T> getResults() {
        return Optional.ofNullable(this.results).map(ArrayList::new).orElse(null);
    }

    public void setResults(List<T> results) {
        this.results = Optional.ofNullable(results).map(ArrayList::new).orElse(null);
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }

    public Boolean getMaxResultCountReached() {
        return this.maxResultCountReached;
    }

    public void setMaxResultCountReached(Boolean maxResultCountReached) {
        this.maxResultCountReached = maxResultCountReached;
    }
}

