/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.DataStatus;
import eu.europeana.metis.core.workflow.plugins.EcloudBasePluginParameters;
import eu.europeana.metis.core.workflow.plugins.ExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ExecutionProgress;
import eu.europeana.metis.core.workflow.plugins.MetisPlugin;
import eu.europeana.metis.exception.ExternalTaskException;
import java.util.Date;
import java.util.Optional;

public interface ExecutablePlugin<M extends ExecutablePluginMetadata>
extends MetisPlugin<M> {
    public Date getUpdatedDate();

    public void setUpdatedDate(Date var1);

    public String getExternalTaskId();

    public void setExternalTaskId(String var1);

    public ExecutionProgress getExecutionProgress();

    public void setExecutionProgress(ExecutionProgress var1);

    public DataStatus getDataStatus();

    public static DataStatus getDataStatus(AbstractExecutablePlugin plugin) {
        return Optional.ofNullable(plugin.getDataStatus()).orElse(DataStatus.VALID);
    }

    public void setDataStatus(DataStatus var1);

    public String getTopologyName();

    public void execute(String var1, DpsClient var2, EcloudBasePluginParameters var3) throws ExternalTaskException;

    public MonitorResult monitor(DpsClient var1) throws ExternalTaskException;

    public void cancel(DpsClient var1, String var2) throws ExternalTaskException;

    public static class MonitorResult {
        private final TaskState taskState;
        private final String taskInfo;

        public MonitorResult(TaskState taskState, String taskInfo) {
            this.taskState = taskState;
            this.taskInfo = taskInfo;
        }

        public TaskState getTaskState() {
            return this.taskState;
        }

        public String getTaskInfo() {
            return this.taskInfo;
        }
    }
}

