/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPlugin;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPlugin;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPlugin;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPlugin;
import eu.europeana.metis.core.workflow.plugins.MetisPlugin;
import eu.europeana.metis.core.workflow.plugins.NormalizationPlugin;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.TransformationPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPlugin;
import java.util.Date;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Indexed;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="pluginType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=OaipmhHarvestPlugin.class, name="OAIPMH_HARVEST"), @JsonSubTypes.Type(value=HTTPHarvestPlugin.class, name="HTTP_HARVEST"), @JsonSubTypes.Type(value=ValidationInternalPlugin.class, name="VALIDATION_INTERNAL"), @JsonSubTypes.Type(value=TransformationPlugin.class, name="TRANSFORMATION"), @JsonSubTypes.Type(value=ValidationExternalPlugin.class, name="VALIDATION_EXTERNAL"), @JsonSubTypes.Type(value=NormalizationPlugin.class, name="NORMALIZATION"), @JsonSubTypes.Type(value=EnrichmentPlugin.class, name="ENRICHMENT"), @JsonSubTypes.Type(value=MediaProcessPlugin.class, name="MEDIA_PROCESS"), @JsonSubTypes.Type(value=LinkCheckingPlugin.class, name="LINK_CHECKING"), @JsonSubTypes.Type(value=IndexToPreviewPlugin.class, name="PREVIEW"), @JsonSubTypes.Type(value=IndexToPublishPlugin.class, name="PUBLISH")})
@Embedded
public abstract class AbstractMetisPlugin<M extends AbstractMetisPluginMetadata>
implements MetisPlugin<M> {
    protected final PluginType pluginType;
    @Indexed
    private String id;
    private PluginStatus pluginStatus = PluginStatus.INQUEUE;
    private String failMessage;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date startedDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date finishedDate;
    private M pluginMetadata;

    protected AbstractMetisPlugin(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    AbstractMetisPlugin(PluginType pluginType, M pluginMetadata) {
        this.pluginType = pluginType;
        this.pluginMetadata = pluginMetadata;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public PluginType getPluginType() {
        return this.pluginType;
    }

    @Override
    public M getPluginMetadata() {
        return this.pluginMetadata;
    }

    @Override
    public void setPluginMetadata(M pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
    }

    @Override
    public Date getStartedDate() {
        return this.startedDate == null ? null : new Date(this.startedDate.getTime());
    }

    @Override
    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate == null ? null : new Date(startedDate.getTime());
    }

    @Override
    public Date getFinishedDate() {
        return this.finishedDate == null ? null : new Date(this.finishedDate.getTime());
    }

    @Override
    public void setFinishedDate(Date finishedDate) {
        this.finishedDate = finishedDate == null ? null : new Date(finishedDate.getTime());
    }

    @Override
    public PluginStatus getPluginStatus() {
        return this.pluginStatus;
    }

    @Override
    public void setPluginStatus(PluginStatus pluginStatus) {
        this.pluginStatus = pluginStatus;
    }

    @Override
    public void setPluginStatusAndResetFailMessage(PluginStatus pluginStatus) {
        this.setPluginStatus(pluginStatus);
        this.setFailMessage(null);
    }

    @Override
    public String getFailMessage() {
        return this.failMessage;
    }

    @Override
    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }
}

