/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.execution.overview;

import eu.europeana.metis.core.rest.execution.overview.PluginProgressView;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExecutionProgressView {
    private static final Set<PluginStatus> EXECUTING_STATUS_SET = Stream.of(PluginStatus.RUNNING, PluginStatus.CLEANING, PluginStatus.PENDING).collect(Collectors.toSet());
    private static final Set<PluginStatus> FINISHED_STATUS_SET = Stream.of(PluginStatus.FINISHED, PluginStatus.FAILED, PluginStatus.CANCELLED).collect(Collectors.toSet());
    private int stepsDone;
    private int stepsTotal;
    private PluginProgressView currentPluginProgress;

    ExecutionProgressView() {
    }

    ExecutionProgressView(WorkflowExecution execution) {
        this.stepsDone = (int)execution.getMetisPlugins().stream().map(AbstractMetisPlugin::getPluginStatus).filter(FINISHED_STATUS_SET::contains).count();
        AbstractMetisPlugin currentPlugin = execution.getMetisPlugins().stream().filter(plugin -> EXECUTING_STATUS_SET.contains((Object)plugin.getPluginStatus())).findFirst().orElse(null);
        this.stepsTotal = execution.getMetisPlugins().size();
        if (currentPlugin instanceof AbstractExecutablePlugin) {
            this.currentPluginProgress = new PluginProgressView(((AbstractExecutablePlugin)currentPlugin).getExecutionProgress());
        }
    }

    public int getStepsDone() {
        return this.stepsDone;
    }

    public int getStepsTotal() {
        return this.stepsTotal;
    }

    public PluginProgressView getCurrentPluginProgress() {
        return this.currentPluginProgress;
    }
}

