/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.dataset;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import eu.europeana.metis.core.common.Country;
import eu.europeana.metis.core.common.CountryDeserializer;
import eu.europeana.metis.core.common.CountrySerializer;
import eu.europeana.metis.core.common.Language;
import eu.europeana.metis.core.common.LanguageDeserializer;
import eu.europeana.metis.core.common.LanguageSerializer;
import eu.europeana.metis.core.workflow.HasMongoObjectId;
import eu.europeana.metis.json.ObjectIdSerializer;
import java.util.Date;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Indexes;

@Entity
@Indexes(value={@Index(fields={@Field(value="organizationId"), @Field(value="datasetName")}, options=@IndexOptions(unique=true))})
public class Dataset
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    @Indexed(options=@IndexOptions(unique=true))
    private String ecloudDatasetId;
    private String datasetId;
    @Indexed
    private String datasetName;
    @Indexed
    private String organizationId;
    @Indexed
    private String organizationName;
    @Indexed
    private String provider;
    @Indexed
    private String intermediateProvider;
    @Indexed
    private String dataProvider;
    @Indexed
    private String createdByUserId;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date createdDate;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    private String replacedBy;
    private String replaces;
    @JsonSerialize(using=CountrySerializer.class)
    @JsonDeserialize(using=CountryDeserializer.class)
    private Country country;
    @JsonSerialize(using=LanguageSerializer.class)
    @JsonDeserialize(using=LanguageDeserializer.class)
    private Language language;
    private String description;
    private Boolean unfitForPublication;
    private String notes;
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId xsltId;

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getEcloudDatasetId() {
        return this.ecloudDatasetId;
    }

    public void setEcloudDatasetId(String ecloudDatasetId) {
        this.ecloudDatasetId = ecloudDatasetId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getIntermediateProvider() {
        return this.intermediateProvider;
    }

    public void setIntermediateProvider(String intermediateProvider) {
        this.intermediateProvider = intermediateProvider;
    }

    public String getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(String dataProvider) {
        this.dataProvider = dataProvider;
    }

    public String getCreatedByUserId() {
        return this.createdByUserId;
    }

    public void setCreatedByUserId(String createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = new Date(createdDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public String getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(String replacedBy) {
        this.replacedBy = replacedBy;
    }

    public String getReplaces() {
        return this.replaces;
    }

    public void setReplaces(String replaces) {
        this.replaces = replaces;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getUnfitForPublication() {
        return this.unfitForPublication;
    }

    public void setUnfitForPublication(Boolean unfitForPublication) {
        this.unfitForPublication = unfitForPublication;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ObjectId getXsltId() {
        return this.xsltId;
    }

    public void setXsltId(ObjectId xsltId) {
        this.xsltId = xsltId;
    }
}

