/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public enum Language {
    AR("Arabic"),
    AZ("Azerbaijani"),
    BE("Belarusian"),
    BG("Bulgarian"),
    BS("Bosnian"),
    CA("Catalan"),
    CNR("Montenegrin"),
    CS("Czech"),
    CY("Welsh"),
    DA("Danish"),
    DE("German"),
    EL("Greek"),
    EN("English"),
    ES("Spanish"),
    ET("Estonian"),
    EU("Basque"),
    FI("Finnish"),
    FR("French"),
    GA("Irish"),
    GD("Gaelic (Scottish)"),
    GL("Galician"),
    HE("Hebrew"),
    HI("Hindi"),
    HR("Croatian (hrvatski jezik)"),
    HU("Hungarian"),
    HY("Armenian"),
    IE("Interlingue"),
    IS("Icelandic"),
    IT("Italian"),
    JA("Japanese"),
    KA("Georgian"),
    KO("Korean"),
    LT("Lithuanian"),
    LV("Latvian (Lettish)"),
    MK("Macedonian"),
    MT("Maltese"),
    MUL("Multilingual Content"),
    NL("Dutch"),
    NO("Norwegian"),
    PL("Polish"),
    PT("Portugese"),
    RO("Romanian"),
    RU("Russian"),
    SK("Slovak"),
    SL("Slovenian"),
    SQ("Albanian"),
    SR("Serbian"),
    SV("Swedish"),
    TR("Turkish"),
    UK("Ukrainian"),
    YI("Yiddish"),
    ZH("Chinese");

    private String name;

    private Language(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Language getLanguageFromEnumName(String enumName) {
        for (Language language : Language.values()) {
            if (!language.name().equalsIgnoreCase(enumName)) continue;
            return language;
        }
        return null;
    }

    public static List<Language> getLanguageListSortedByName() {
        List<Language> languages = Arrays.asList(Language.values());
        languages.sort(Comparator.comparing(Language::getName));
        return languages;
    }
}

