/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPlugin;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPlugin;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPlugin;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.NormalizationPlugin;
import eu.europeana.metis.core.workflow.plugins.NormalizationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.TransformationPlugin;
import eu.europeana.metis.core.workflow.plugins.TransformationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPluginMetadata;
import java.util.function.Function;

public enum ExecutablePluginType {
    HTTP_HARVEST(new PluginCreator<HTTPHarvestPluginMetadata>(HTTPHarvestPluginMetadata.class, HTTPHarvestPlugin::new), false, PluginType.HTTP_HARVEST),
    OAIPMH_HARVEST(new PluginCreator<OaipmhHarvestPluginMetadata>(OaipmhHarvestPluginMetadata.class, OaipmhHarvestPlugin::new), false, PluginType.OAIPMH_HARVEST),
    ENRICHMENT(new PluginCreator<EnrichmentPluginMetadata>(EnrichmentPluginMetadata.class, EnrichmentPlugin::new), false, PluginType.ENRICHMENT),
    MEDIA_PROCESS(new PluginCreator<MediaProcessPluginMetadata>(MediaProcessPluginMetadata.class, MediaProcessPlugin::new), false, PluginType.MEDIA_PROCESS),
    LINK_CHECKING(new PluginCreator<LinkCheckingPluginMetadata>(LinkCheckingPluginMetadata.class, LinkCheckingPlugin::new), true, PluginType.LINK_CHECKING),
    VALIDATION_EXTERNAL(new PluginCreator<ValidationExternalPluginMetadata>(ValidationExternalPluginMetadata.class, ValidationExternalPlugin::new), false, PluginType.VALIDATION_EXTERNAL),
    TRANSFORMATION(new PluginCreator<TransformationPluginMetadata>(TransformationPluginMetadata.class, TransformationPlugin::new), false, PluginType.TRANSFORMATION),
    VALIDATION_INTERNAL(new PluginCreator<ValidationInternalPluginMetadata>(ValidationInternalPluginMetadata.class, ValidationInternalPlugin::new), false, PluginType.VALIDATION_INTERNAL),
    NORMALIZATION(new PluginCreator<NormalizationPluginMetadata>(NormalizationPluginMetadata.class, NormalizationPlugin::new), false, PluginType.NORMALIZATION),
    PREVIEW(new PluginCreator<IndexToPreviewPluginMetadata>(IndexToPreviewPluginMetadata.class, IndexToPreviewPlugin::new), false, PluginType.PREVIEW),
    PUBLISH(new PluginCreator<IndexToPublishPluginMetadata>(IndexToPublishPluginMetadata.class, IndexToPublishPlugin::new), false, PluginType.PUBLISH);

    private final PluginCreator<?> pluginCreator;
    private final boolean revisionLess;
    private final PluginType pluginType;

    private ExecutablePluginType(PluginCreator<?> pluginCreator, boolean revisionLess, PluginType pluginType) {
        this.pluginCreator = pluginCreator;
        this.revisionLess = revisionLess;
        this.pluginType = pluginType;
    }

    public PluginType toPluginType() {
        return this.pluginType;
    }

    public AbstractExecutablePlugin getNewPlugin(AbstractMetisPluginMetadata metaData) {
        return this.pluginCreator.createPlugin(metaData);
    }

    public boolean isRevisionLess() {
        return this.revisionLess;
    }

    @JsonCreator
    public static ExecutablePluginType getPluginTypeFromEnumName(@JsonProperty(value="pluginName") String enumName) {
        for (ExecutablePluginType pluginType : ExecutablePluginType.values()) {
            if (!pluginType.name().equalsIgnoreCase(enumName)) continue;
            return pluginType;
        }
        return null;
    }

    private static class PluginCreator<M extends AbstractExecutablePluginMetadata> {
        private Class<M> pluginMetadataType;
        private Function<M, AbstractExecutablePlugin<M>> pluginCreatorFunction;

        PluginCreator(Class<M> pluginMetadataType, Function<M, AbstractExecutablePlugin<M>> pluginCreatorFunction) {
            this.pluginMetadataType = pluginMetadataType;
            this.pluginCreatorFunction = pluginCreatorFunction;
        }

        AbstractExecutablePlugin<M> createPlugin(AbstractMetisPluginMetadata pluginMetadata) {
            AbstractExecutablePluginMetadata castPluginMetadata = (AbstractExecutablePluginMetadata)this.pluginMetadataType.cast(pluginMetadata);
            return this.pluginCreatorFunction.apply(castPluginMetadata);
        }
    }
}

