/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.execution.overview;

import eu.europeana.metis.core.rest.execution.overview.PluginProgressView;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import java.util.Date;
import java.util.Optional;

public class PluginSummaryView {
    private PluginType pluginType;
    private PluginStatus pluginStatus;
    private String failMessage;
    private Date startedDate;
    private Date updatedDate;
    private Date finishedDate;
    private PluginProgressView progress;

    PluginSummaryView() {
    }

    PluginSummaryView(AbstractMetisPlugin plugin) {
        this.pluginType = plugin.getPluginType();
        this.pluginStatus = plugin.getPluginStatus();
        this.failMessage = plugin.getFailMessage();
        this.startedDate = plugin.getStartedDate();
        this.finishedDate = plugin.getFinishedDate();
        if (plugin instanceof AbstractExecutablePlugin) {
            this.updatedDate = ((AbstractExecutablePlugin)plugin).getUpdatedDate();
            this.progress = new PluginProgressView(((AbstractExecutablePlugin)plugin).getExecutionProgress());
        }
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public PluginStatus getPluginStatus() {
        return this.pluginStatus;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public Date getStartedDate() {
        return Optional.ofNullable(this.startedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public Date getUpdatedDate() {
        return Optional.ofNullable(this.updatedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public Date getFinishedDate() {
        return Optional.ofNullable(this.finishedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public PluginProgressView getProgress() {
        return this.progress;
    }
}

