/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import com.fasterxml.jackson.annotation.JsonFormat;
import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.metis.core.workflow.CancelledSystemId;
import eu.europeana.metis.core.workflow.plugins.AbstractExecutablePluginMetadata;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.DataStatus;
import eu.europeana.metis.core.workflow.plugins.EcloudBasePluginParameters;
import eu.europeana.metis.core.workflow.plugins.ExecutionProgress;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.exception.ExternalTaskException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mongodb.morphia.annotations.Indexed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutablePlugin<M extends AbstractExecutablePluginMetadata>
extends AbstractMetisPlugin<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExecutablePlugin.class);
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    private String externalTaskId;
    private ExecutionProgress executionProgress = new ExecutionProgress();
    private DataStatus dataStatus;

    AbstractExecutablePlugin(PluginType pluginType) {
        super(pluginType);
    }

    AbstractExecutablePlugin(PluginType pluginType, M pluginMetadata) {
        super(pluginType, pluginMetadata);
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    public ExecutionProgress getExecutionProgress() {
        return this.executionProgress;
    }

    public void setExecutionProgress(ExecutionProgress executionProgress) {
        this.executionProgress = executionProgress;
    }

    public DataStatus getDataStatus() {
        return this.dataStatus;
    }

    public static DataStatus getDataStatus(AbstractExecutablePlugin plugin) {
        return Optional.ofNullable(plugin.getDataStatus()).orElse(DataStatus.VALID);
    }

    public void setDataStatus(DataStatus dataStatus) {
        this.dataStatus = dataStatus;
    }

    public abstract String getTopologyName();

    private Revision createOutputRevisionForExecution(String ecloudProvider, boolean published) {
        return new Revision(this.getPluginType().name(), ecloudProvider, this.getStartedDate(), false, published, false);
    }

    private DpsTask createDpsTaskForPluginWithExistingDataset(Map<String, String> parameters, EcloudBasePluginParameters ecloudBasePluginParameters, boolean publish) {
        DpsTask dpsTask = new DpsTask();
        EnumMap<InputDataType, List<String>> dataEntries = new EnumMap<InputDataType, List<String>>(InputDataType.class);
        dataEntries.put(InputDataType.DATASET_URLS, Collections.singletonList(String.format("%s/data-providers/%s/data-sets/%s", ecloudBasePluginParameters.getEcloudBaseUrl(), ecloudBasePluginParameters.getEcloudProvider(), ecloudBasePluginParameters.getEcloudDatasetId())));
        dpsTask.setInputData(dataEntries);
        dpsTask.setParameters(parameters);
        dpsTask.setOutputRevision(this.createOutputRevisionForExecution(ecloudBasePluginParameters.getEcloudProvider(), publish));
        return dpsTask;
    }

    DpsTask createDpsTaskForHarvestPlugin(EcloudBasePluginParameters ecloudBasePluginParameters, Map<String, String> extraParameters, String targetUrl) {
        DpsTask dpsTask = new DpsTask();
        EnumMap<InputDataType, List<String>> dataEntries = new EnumMap<InputDataType, List<String>>(InputDataType.class);
        dataEntries.put(InputDataType.REPOSITORY_URLS, Collections.singletonList(targetUrl));
        dpsTask.setInputData(dataEntries);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParameters != null) {
            parameters.putAll(extraParameters);
        }
        parameters.put("PROVIDER_ID", ecloudBasePluginParameters.getEcloudProvider());
        parameters.put("OUTPUT_DATA_SETS", String.format("%s/data-providers/%s/data-sets/%s", ecloudBasePluginParameters.getEcloudBaseUrl(), ecloudBasePluginParameters.getEcloudProvider(), ecloudBasePluginParameters.getEcloudDatasetId()));
        parameters.put("NEW_REPRESENTATION_NAME", AbstractExecutablePlugin.getRepresentationName());
        dpsTask.setParameters(parameters);
        dpsTask.setOutputRevision(this.createOutputRevisionForExecution(ecloudBasePluginParameters.getEcloudProvider(), false));
        return dpsTask;
    }

    DpsTask createDpsTaskForProcessPlugin(EcloudBasePluginParameters ecloudBasePluginParameters, Map<String, String> extraParameters) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParameters != null) {
            parameters.putAll(extraParameters);
        }
        parameters.put("REPRESENTATION_NAME", AbstractExecutablePlugin.getRepresentationName());
        parameters.put("REVISION_NAME", ((AbstractExecutablePluginMetadata)this.getPluginMetadata()).getRevisionNamePreviousPlugin());
        parameters.put("REVISION_PROVIDER", ecloudBasePluginParameters.getEcloudProvider());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.US);
        parameters.put("REVISION_TIMESTAMP", dateFormat.format(((AbstractExecutablePluginMetadata)this.getPluginMetadata()).getRevisionTimestampPreviousPlugin()));
        parameters.put("PREVIOUS_TASK_ID", ecloudBasePluginParameters.getPreviousExternalTaskId());
        parameters.put("NEW_REPRESENTATION_NAME", AbstractExecutablePlugin.getRepresentationName());
        parameters.put("OUTPUT_DATA_SETS", String.format("%s/data-providers/%s/data-sets/%s", ecloudBasePluginParameters.getEcloudBaseUrl(), ecloudBasePluginParameters.getEcloudProvider(), ecloudBasePluginParameters.getEcloudDatasetId()));
        return this.createDpsTaskForPluginWithExistingDataset(parameters, ecloudBasePluginParameters, false);
    }

    DpsTask createDpsTaskForIndexPlugin(EcloudBasePluginParameters ecloudBasePluginParameters, String datasetId, boolean useAlternativeIndexingEnvironment, boolean preserveTimestamps, String targetDatabase) {
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        extraParameters.put("METIS_DATASET_ID", datasetId);
        extraParameters.put("TARGET_INDEXING_DATABASE", targetDatabase);
        extraParameters.put("USE_ALT_INDEXING_ENV", String.valueOf(useAlternativeIndexingEnvironment));
        extraParameters.put("PRESERVE_TIMESTAMPS", String.valueOf(preserveTimestamps));
        return this.createDpsTaskForProcessPlugin(ecloudBasePluginParameters, extraParameters);
    }

    Map<String, String> createParametersForHostConnectionLimits(Map<String, Integer> connectionLimitToDomains) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (connectionLimitToDomains != null) {
            connectionLimitToDomains.entrySet().stream().filter(entry -> !StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) && entry.getValue() != null).forEach(entry -> parameters.put("host.limit." + (String)entry.getKey(), Integer.toString((Integer)entry.getValue())));
        }
        return parameters;
    }

    Map<String, String> createParametersForValidation(String urlOfSchemasZip, String schemaRootPath, String schematronRootPath) {
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        extraParameters.put("SCHEMA_NAME", urlOfSchemasZip);
        extraParameters.put("ROOT_LOCATION", schemaRootPath);
        extraParameters.put("SCHEMATRON_LOCATION", schematronRootPath);
        return extraParameters;
    }

    abstract DpsTask prepareDpsTask(EcloudBasePluginParameters var1);

    public void execute(DpsClient dpsClient, EcloudBasePluginParameters ecloudBasePluginParameters) throws ExternalTaskException {
        String pluginTypeName = this.getPluginType().name();
        LOGGER.info("Starting execution of {} plugin for ecloudDatasetId {}", (Object)pluginTypeName, (Object)ecloudBasePluginParameters.getEcloudDatasetId());
        try {
            DpsTask dpsTask = this.prepareDpsTask(ecloudBasePluginParameters);
            this.setExternalTaskId(Long.toString(dpsClient.submitTask(dpsTask, this.getTopologyName())));
            this.setDataStatus(DataStatus.VALID);
        }
        catch (DpsException | RuntimeException e) {
            throw new ExternalTaskException("Submitting task failed", e);
        }
        LOGGER.info("Submitted task with externalTaskId: {}", (Object)this.getExternalTaskId());
    }

    public MonitorResult monitor(DpsClient dpsClient) throws ExternalTaskException {
        TaskInfo taskInfo;
        LOGGER.info("Requesting progress information for externalTaskId: {}", (Object)this.getExternalTaskId());
        try {
            taskInfo = dpsClient.getTaskProgress(this.getTopologyName(), Long.parseLong(this.getExternalTaskId()));
        }
        catch (DpsException | RuntimeException e) {
            throw new ExternalTaskException("Requesting task progress failed", e);
        }
        LOGGER.info("Task information received for externalTaskId: {}", (Object)this.getExternalTaskId());
        this.getExecutionProgress().copyExternalTaskInformation(taskInfo);
        return new MonitorResult(taskInfo.getState(), taskInfo.getInfo());
    }

    public void cancel(DpsClient dpsClient, String cancelledById) throws ExternalTaskException {
        LOGGER.info("Cancel execution for externalTaskId: {}", (Object)this.getExternalTaskId());
        try {
            dpsClient.killTask(this.getTopologyName(), Long.parseLong(this.getExternalTaskId()), CancelledSystemId.SYSTEM_MINUTE_CAP_EXPIRE.name().equals(cancelledById) ? "Cancelled By System" : "Cancelled By User");
        }
        catch (DpsException | RuntimeException e) {
            throw new ExternalTaskException("Requesting task cancellation failed", e);
        }
    }

    public static class MonitorResult {
        private final TaskState taskState;
        private final String taskInfo;

        public MonitorResult(TaskState taskState, String taskInfo) {
            this.taskState = taskState;
            this.taskInfo = taskInfo;
        }

        public TaskState getTaskState() {
            return this.taskState;
        }

        public String getTaskInfo() {
            return this.taskInfo;
        }
    }
}

