/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import eu.europeana.metis.core.workflow.HasMongoObjectId;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.json.ObjectIdSerializer;
import java.util.Date;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Indexes;

@Entity
@Indexes(value={@Index(fields={@Field(value="datasetId")})})
public class ScheduledWorkflow
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    private String datasetId;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssXXX")
    private Date pointerDate;
    private ScheduleFrequence scheduleFrequence;
    private int workflowPriority;

    public ScheduledWorkflow() {
    }

    public ScheduledWorkflow(Date pointerDate, String datasetId, ScheduleFrequence scheduleFrequence, int workflowPriority) {
        this.pointerDate = pointerDate == null ? null : new Date(pointerDate.getTime());
        this.datasetId = datasetId;
        this.scheduleFrequence = scheduleFrequence;
        this.workflowPriority = workflowPriority;
    }

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public Date getPointerDate() {
        return this.pointerDate == null ? null : new Date(this.pointerDate.getTime());
    }

    public void setPointerDate(Date pointerDate) {
        this.pointerDate = pointerDate == null ? null : new Date(pointerDate.getTime());
    }

    public ScheduleFrequence getScheduleFrequence() {
        return this.scheduleFrequence;
    }

    public void setScheduleFrequence(ScheduleFrequence scheduleFrequence) {
        this.scheduleFrequence = scheduleFrequence;
    }

    public int getWorkflowPriority() {
        return this.workflowPriority;
    }

    public void setWorkflowPriority(int workflowPriority) {
        this.workflowPriority = workflowPriority;
    }
}

