/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest.execution.overview;

import eu.europeana.metis.core.rest.execution.overview.PluginSummaryView;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExecutionSummaryView {
    private String id;
    private WorkflowStatus workflowStatus;
    private boolean cancelling;
    private Date createdDate;
    private Date startedDate;
    private Date updatedDate;
    private Date finishedDate;
    private List<PluginSummaryView> plugins;

    ExecutionSummaryView() {
    }

    ExecutionSummaryView(WorkflowExecution execution) {
        this.id = execution.getId().toString();
        this.workflowStatus = execution.getWorkflowStatus();
        this.cancelling = execution.isCancelling();
        this.createdDate = execution.getCreatedDate();
        this.startedDate = execution.getStartedDate();
        this.updatedDate = execution.getUpdatedDate();
        this.finishedDate = execution.getFinishedDate();
        this.plugins = execution.getMetisPlugins().stream().map(PluginSummaryView::new).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkflowStatus getWorkflowStatus() {
        return this.workflowStatus;
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public Date getCreatedDate() {
        return Optional.ofNullable(this.createdDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public Date getStartedDate() {
        return Optional.ofNullable(this.startedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public Date getUpdatedDate() {
        return Optional.ofNullable(this.updatedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public Date getFinishedDate() {
        return Optional.ofNullable(this.finishedDate).map(Date::getTime).map(Date::new).orElse(null);
    }

    public List<PluginSummaryView> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }
}

