/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import eu.europeana.cloud.client.dps.rest.DpsClient;
import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.model.dps.TaskInfo;
import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.InputDataType;
import eu.europeana.cloud.service.dps.exception.DpsException;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPlugin;
import eu.europeana.metis.core.workflow.plugins.ExecutionProgress;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPlugin;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPlugin;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPlugin;
import eu.europeana.metis.core.workflow.plugins.NormalizationPlugin;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.PluginStatus;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.TransformationPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPlugin;
import eu.europeana.metis.exception.ExternalTaskException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Indexed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="pluginType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=OaipmhHarvestPlugin.class, name="OAIPMH_HARVEST"), @JsonSubTypes.Type(value=HTTPHarvestPlugin.class, name="HTTP_HARVEST"), @JsonSubTypes.Type(value=ValidationInternalPlugin.class, name="VALIDATION_INTERNAL"), @JsonSubTypes.Type(value=TransformationPlugin.class, name="TRANSFORMATION"), @JsonSubTypes.Type(value=ValidationExternalPlugin.class, name="VALIDATION_EXTERNAL"), @JsonSubTypes.Type(value=NormalizationPlugin.class, name="NORMALIZATION"), @JsonSubTypes.Type(value=EnrichmentPlugin.class, name="ENRICHMENT"), @JsonSubTypes.Type(value=MediaProcessPlugin.class, name="MEDIA_PROCESS"), @JsonSubTypes.Type(value=LinkCheckingPlugin.class, name="LINK_CHECKING"), @JsonSubTypes.Type(value=IndexToPreviewPlugin.class, name="PREVIEW"), @JsonSubTypes.Type(value=IndexToPublishPlugin.class, name="PUBLISH")})
@Embedded
public abstract class AbstractMetisPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetisPlugin.class);
    protected final PluginType pluginType;
    private static final String REPRESENTATION_NAME = "metadataRecord";
    @Indexed
    private String id;
    private PluginStatus pluginStatus = PluginStatus.INQUEUE;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date startedDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date updatedDate;
    @Indexed
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date finishedDate;
    private String externalTaskId;
    private ExecutionProgress executionProgress = new ExecutionProgress();
    private AbstractMetisPluginMetadata pluginMetadata;

    AbstractMetisPlugin(PluginType pluginType) {
        this.pluginType = pluginType;
    }

    AbstractMetisPlugin(PluginType pluginType, AbstractMetisPluginMetadata pluginMetadata) {
        this.pluginType = pluginType;
        this.pluginMetadata = pluginMetadata;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PluginType getPluginType() {
        return this.pluginType;
    }

    public static String getRepresentationName() {
        return REPRESENTATION_NAME;
    }

    public AbstractMetisPluginMetadata getPluginMetadata() {
        return this.pluginMetadata;
    }

    public void setPluginMetadata(AbstractMetisPluginMetadata pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
    }

    public Date getStartedDate() {
        return this.startedDate == null ? null : new Date(this.startedDate.getTime());
    }

    public void setStartedDate(Date startedDate) {
        this.startedDate = startedDate == null ? null : new Date(startedDate.getTime());
    }

    public Date getFinishedDate() {
        return this.finishedDate == null ? null : new Date(this.finishedDate.getTime());
    }

    public void setFinishedDate(Date finishedDate) {
        this.finishedDate = finishedDate == null ? null : new Date(finishedDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public PluginStatus getPluginStatus() {
        return this.pluginStatus;
    }

    public void setPluginStatus(PluginStatus pluginStatus) {
        this.pluginStatus = pluginStatus;
    }

    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    public ExecutionProgress getExecutionProgress() {
        return this.executionProgress;
    }

    public void setExecutionProgress(ExecutionProgress executionProgress) {
        this.executionProgress = executionProgress;
    }

    public abstract String getTopologyName();

    private Revision createOutputRevisionForExecution(String ecloudProvider, boolean published) {
        return new Revision(this.getPluginType().name(), ecloudProvider, this.getStartedDate(), false, published, false);
    }

    private DpsTask createDpsTaskForPluginWithExistingDataset(Map<String, String> parameters, String ecloudBaseUrl, String ecloudProvider, String ecloudDataset, boolean publish) {
        DpsTask dpsTask = new DpsTask();
        EnumMap<InputDataType, List<String>> dataEntries = new EnumMap<InputDataType, List<String>>(InputDataType.class);
        dataEntries.put(InputDataType.DATASET_URLS, Collections.singletonList(String.format("%s/data-providers/%s/data-sets/%s", ecloudBaseUrl, ecloudProvider, ecloudDataset)));
        dpsTask.setInputData(dataEntries);
        dpsTask.setParameters(parameters);
        dpsTask.setOutputRevision(this.createOutputRevisionForExecution(ecloudProvider, publish));
        return dpsTask;
    }

    DpsTask createDpsTaskForHarvestPlugin(Map<String, String> extraParameters, String targetUrl, String ecloudBaseUrl, String ecloudProvider, String ecloudDataset) {
        DpsTask dpsTask = new DpsTask();
        EnumMap<InputDataType, List<String>> dataEntries = new EnumMap<InputDataType, List<String>>(InputDataType.class);
        dataEntries.put(InputDataType.REPOSITORY_URLS, Collections.singletonList(targetUrl));
        dpsTask.setInputData(dataEntries);
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParameters != null) {
            parameters.putAll(extraParameters);
        }
        parameters.put("PROVIDER_ID", ecloudProvider);
        parameters.put("OUTPUT_DATA_SETS", String.format("%s/data-providers/%s/data-sets/%s", ecloudBaseUrl, ecloudProvider, ecloudDataset));
        parameters.put("NEW_REPRESENTATION_NAME", AbstractMetisPlugin.getRepresentationName());
        dpsTask.setParameters(parameters);
        dpsTask.setOutputRevision(this.createOutputRevisionForExecution(ecloudProvider, false));
        return dpsTask;
    }

    DpsTask createDpsTaskForProcessPlugin(Map<String, String> extraParameters, String ecloudBaseUrl, String ecloudProvider, String ecloudDataset) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParameters != null) {
            parameters.putAll(extraParameters);
        }
        parameters.put("REPRESENTATION_NAME", AbstractMetisPlugin.getRepresentationName());
        parameters.put("REVISION_NAME", this.getPluginMetadata().getRevisionNamePreviousPlugin());
        parameters.put("REVISION_PROVIDER", ecloudProvider);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        parameters.put("REVISION_TIMESTAMP", dateFormat.format(this.getPluginMetadata().getRevisionTimestampPreviousPlugin()));
        parameters.put("NEW_REPRESENTATION_NAME", AbstractMetisPlugin.getRepresentationName());
        parameters.put("OUTPUT_DATA_SETS", String.format("%s/data-providers/%s/data-sets/%s", ecloudBaseUrl, ecloudProvider, ecloudDataset));
        return this.createDpsTaskForPluginWithExistingDataset(parameters, ecloudBaseUrl, ecloudProvider, ecloudDataset, false);
    }

    DpsTask createDpsTaskForIndexPlugin(String datasetId, boolean useAlternativeIndexingEnvironment, boolean preserveTimestamps, String targetDatabase, String ecloudBaseUrl, String ecloudProvider, String ecloudDataset) {
        HashMap<String, String> extraParameters = new HashMap<String, String>();
        extraParameters.put("METIS_DATASET_ID", datasetId);
        extraParameters.put("TARGET_INDEXING_DATABASE", targetDatabase);
        extraParameters.put("USE_ALT_INDEXING_ENV", String.valueOf(useAlternativeIndexingEnvironment));
        extraParameters.put("PRESERVE_TIMESTAMPS", String.valueOf(preserveTimestamps));
        return this.createDpsTaskForProcessPlugin(extraParameters, ecloudBaseUrl, ecloudProvider, ecloudDataset);
    }

    Map<String, String> createParametersForHostConnectionLimits(Map<String, Integer> connectionLimitToDomains) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (connectionLimitToDomains != null) {
            connectionLimitToDomains.entrySet().stream().filter(entry -> !StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) && entry.getValue() != null).forEach(entry -> parameters.put("host.limit." + (String)entry.getKey(), Integer.toString((Integer)entry.getValue())));
        }
        return parameters;
    }

    abstract DpsTask prepareDpsTask(String var1, String var2, String var3);

    public void execute(DpsClient dpsClient, String ecloudBaseUrl, String ecloudProvider, String ecloudDataset) throws ExternalTaskException {
        if (!this.getPluginMetadata().isMocked()) {
            String pluginTypeName = this.getPluginType().name();
            LOGGER.info("Starting real execution of {} plugin for ecloudDatasetId {}", (Object)pluginTypeName, (Object)ecloudDataset);
            try {
                DpsTask dpsTask = this.prepareDpsTask(ecloudBaseUrl, ecloudProvider, ecloudDataset);
                this.setExternalTaskId(Long.toString(dpsClient.submitTask(dpsTask, this.getTopologyName())));
            }
            catch (DpsException | RuntimeException e) {
                throw new ExternalTaskException("Submitting task failed", e);
            }
            LOGGER.info("Submitted task with externalTaskId: {}", (Object)this.getExternalTaskId());
        }
    }

    public ExecutionProgress monitor(DpsClient dpsClient) throws ExternalTaskException {
        TaskInfo taskInfo;
        LOGGER.info("Requesting progress information for externalTaskId: {}", (Object)this.getExternalTaskId());
        try {
            taskInfo = dpsClient.getTaskProgress(this.getTopologyName(), Long.parseLong(this.getExternalTaskId()));
        }
        catch (DpsException | RuntimeException e) {
            throw new ExternalTaskException("Requesting task progress failed", e);
        }
        LOGGER.info("Task information received for externalTaskId: {}", (Object)this.getExternalTaskId());
        return this.getExecutionProgress().copyExternalTaskInformation(taskInfo);
    }

    public void cancel(DpsClient dpsClient) throws ExternalTaskException {
        LOGGER.info("Cancel execution for externalTaskId: {}", (Object)this.getExternalTaskId());
        try {
            dpsClient.killTask(this.getTopologyName(), Long.parseLong(this.getExternalTaskId()));
        }
        catch (DpsException | RuntimeException e) {
            throw new ExternalTaskException("Requesting task cancellation failed", e);
        }
    }
}

