/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import eu.europeana.metis.core.workflow.HasMongoObjectId;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.json.ObjectIdSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bson.types.ObjectId;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.annotations.Indexes;

@Entity
@Indexes(value={@Index(fields={@Field(value="datasetId")}, options=@IndexOptions(unique=true))})
@JsonPropertyOrder(value={"id", "datasetId", "metisPluginMetadata"})
public class Workflow
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    private String datasetId;
    @JacksonXmlElementWrapper(localName="metisPluginsMetadatas")
    @JacksonXmlProperty(localName="metisPluginsMetadata")
    @Embedded
    private List<AbstractMetisPluginMetadata> metisPluginsMetadata = new ArrayList<AbstractMetisPluginMetadata>();

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public List<AbstractMetisPluginMetadata> getMetisPluginsMetadata() {
        return this.metisPluginsMetadata;
    }

    public void setMetisPluginsMetadata(List<AbstractMetisPluginMetadata> metisPluginsMetadata) {
        this.metisPluginsMetadata = metisPluginsMetadata;
    }

    public AbstractMetisPluginMetadata getPluginMetadata(PluginType pluginType) {
        for (AbstractMetisPluginMetadata metisPluginMetadata : this.metisPluginsMetadata) {
            if (metisPluginMetadata.getPluginType() != pluginType) continue;
            return metisPluginMetadata;
        }
        return null;
    }

    public boolean pluginTypeOccursOnlyAfter(PluginType pluginType, Set<PluginType> possibleEarlierPluginTypes) {
        if (pluginType == null) {
            throw new IllegalArgumentException();
        }
        if (possibleEarlierPluginTypes == null) {
            return false;
        }
        boolean earlierPluginTypeFound = false;
        for (AbstractMetisPluginMetadata plugin : this.metisPluginsMetadata) {
            if (plugin.getPluginType() == pluginType) {
                return earlierPluginTypeFound;
            }
            earlierPluginTypeFound = earlierPluginTypeFound || possibleEarlierPluginTypes.contains((Object)plugin.getPluginType());
        }
        return false;
    }
}

