/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import eu.europeana.metis.core.common.CountryDeserializer;
import eu.europeana.metis.core.common.CountrySerializer;

@JsonSerialize(using=CountrySerializer.class)
@JsonDeserialize(using=CountryDeserializer.class)
public enum Country {
    ALBANIA("Albania", "AL"),
    ANDORRA("Andorra", "AD"),
    ARMENIA("Armenia", "AM"),
    AUSTRIA("Austria", "AT"),
    AZERBAIJAN("Azerbaijan", "AZ"),
    AUSTRALIA("Australia", "AU"),
    BELARUS("Belarus", "BY"),
    BELGIUM("Belgium", "BE"),
    BOSNIA_AND_HERZEGOVINA("Bosnia and Herzegovina", "BA"),
    BULGARIA("Bulgaria", "BG"),
    CANADA("Canada", "CA"),
    CHINA("China", "CN"),
    CROATIA("Croatia", "HR"),
    CYRPUS("Cyprus", "CY"),
    CZECH_REPUBLIC("Czech Republic", "CZ"),
    DENMARK("Denmark", "DK"),
    ESTONIA("Estonia", "EE"),
    EUROPE("Europe", "EU"),
    FINLAND("Finland", "FI"),
    FRANCE("France", "FR"),
    GEORGIA("Georgia", "GE"),
    GERMANY("Germany", "DE"),
    GREECE("Greece", "GR"),
    HOLY_SEE_VATICAN_CITY_STATE("Holy See (Vatican City State)", "VA"),
    HUNGARY("Hungary", "HU"),
    ICELAND("Iceland", "IS"),
    INDIA("India", "IN"),
    IRELAND("Ireland", "IE"),
    ITALY("Italy", "IT"),
    ISRAEL("Israel", "IL"),
    JAPAN("Japan", "JP"),
    KAZAKHSTAN("Kazakhstan", "KZ"),
    KOREA("Korea, Republic of", "KR"),
    LATVIA("Latvia", "LV"),
    LEBANON("Lebanon", "LB"),
    LIECHTENSTEIN("Liechtenstein", "LI"),
    LITHUANIA("Lithuania", "LT"),
    LUXEMBOURG("Luxembourg", "LU"),
    MACEDONIA("Macedonia", "MK"),
    MALTA("Malta", "MT"),
    MOLDOVA("Moldova", "MD"),
    MONACO("Monaco", "MC"),
    MONTENEGRO("Montenegro", "ME"),
    NETHERLANDS("Netherlands", "NL"),
    NORWAY("Norway", "NO"),
    POLAND("Poland", "PL"),
    PORTUGAL("Portugal", "PT"),
    ROMANIA("Romania", "RO"),
    RUSSIA("Russia", "RU"),
    SAN_MARINO("San Marino", "SM"),
    SERBIA("Serbia", "RS"),
    SLOVAKIA("Slovakia", "SK"),
    SLOVENIA("Slovenia", "SI"),
    SPAIN("Spain", "ES"),
    SWEDEN("Sweden", "SE"),
    SWITZERLAND("Switzerland", "CH"),
    TURKEY("Turkey", "TR"),
    UKRAINE("Ukraine", "UA"),
    UNITED_KINGDOM("United Kingdom", "GB"),
    UNITED_STATES("United States of America", "US");

    private String name;
    private String isoCode;

    private Country(String name, String isoCode) {
        this.name = name;
        this.isoCode = isoCode;
    }

    public String getName() {
        return this.name;
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public static Country getCountryFromEnumName(String enumName) {
        for (Country country : Country.values()) {
            if (!country.name().equalsIgnoreCase(enumName)) continue;
            return country;
        }
        return null;
    }

    public static Country getCountryFromIsoCode(String isoCode) {
        for (Country country : Country.values()) {
            if (!country.getIsoCode().equalsIgnoreCase(isoCode)) continue;
            return country;
        }
        return null;
    }
}

