/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPlugin;
import eu.europeana.metis.core.workflow.plugins.HTTPHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPreviewPlugin;
import eu.europeana.metis.core.workflow.plugins.IndexToPublishPlugin;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPlugin;
import eu.europeana.metis.core.workflow.plugins.MediaProcessPlugin;
import eu.europeana.metis.core.workflow.plugins.NormalizationPlugin;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPlugin;
import eu.europeana.metis.core.workflow.plugins.TransformationPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPlugin;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPlugin;
import java.util.function.Function;

public enum PluginType {
    HTTP_HARVEST(HTTPHarvestPlugin::new, false),
    OAIPMH_HARVEST(OaipmhHarvestPlugin::new, false),
    ENRICHMENT(EnrichmentPlugin::new, false),
    MEDIA_PROCESS(MediaProcessPlugin::new, false),
    LINK_CHECKING(LinkCheckingPlugin::new, true),
    VALIDATION_EXTERNAL(ValidationExternalPlugin::new, false),
    TRANSFORMATION(TransformationPlugin::new, false),
    VALIDATION_INTERNAL(ValidationInternalPlugin::new, false),
    NORMALIZATION(NormalizationPlugin::new, false),
    PREVIEW(IndexToPreviewPlugin::new, false),
    PUBLISH(IndexToPublishPlugin::new, false);

    private final Function<AbstractMetisPluginMetadata, AbstractMetisPlugin> pluginCreator;
    private final boolean revisionLess;

    private PluginType(Function<AbstractMetisPluginMetadata, AbstractMetisPlugin> pluginCreator, boolean revisionLess) {
        this.pluginCreator = pluginCreator;
        this.revisionLess = revisionLess;
    }

    public AbstractMetisPlugin getNewPlugin(AbstractMetisPluginMetadata metaData) {
        return this.pluginCreator.apply(metaData);
    }

    public boolean isRevisionLess() {
        return this.revisionLess;
    }

    @JsonCreator
    public static PluginType getPluginTypeFromEnumName(@JsonProperty(value="pluginName") String enumName) {
        for (PluginType pluginType : PluginType.values()) {
            if (!pluginType.name().equalsIgnoreCase(enumName)) continue;
            return pluginType;
        }
        return null;
    }
}

