/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.workflow.plugins;

import eu.europeana.cloud.service.dps.DpsTask;
import eu.europeana.cloud.service.dps.OAIPMHHarvestingDetails;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.Topology;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class OaipmhHarvestPlugin
extends AbstractMetisPlugin {
    private final String topologyName = Topology.OAIPMH_HARVEST.getTopologyName();

    OaipmhHarvestPlugin() {
        super(PluginType.OAIPMH_HARVEST);
    }

    OaipmhHarvestPlugin(AbstractMetisPluginMetadata pluginMetadata) {
        super(PluginType.OAIPMH_HARVEST, pluginMetadata);
    }

    @Override
    public String getTopologyName() {
        return this.topologyName;
    }

    @Override
    DpsTask prepareDpsTask(String ecloudBaseUrl, String ecloudProvider, String ecloudDataset) {
        String targetUrl = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getUrl();
        String datasetId = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getDatasetId();
        boolean useDefaultIdentifiers = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).isUseDefaultIdentifiers();
        String identifierPrefixRemoval = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getIdentifierPrefixRemoval();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("METIS_DATASET_ID", datasetId);
        parameters.put("USE_DEFAULT_IDENTIFIERS", String.valueOf(useDefaultIdentifiers));
        if (useDefaultIdentifiers && !StringUtils.isBlank((CharSequence)identifierPrefixRemoval)) {
            parameters.put("MIGRATION_IDENTIFIER_PREFIX", identifierPrefixRemoval);
        }
        DpsTask dpsTask = this.createDpsTaskForHarvestPlugin(parameters, targetUrl, ecloudBaseUrl, ecloudProvider, ecloudDataset);
        String setSpec = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getSetSpec();
        String metadataFormat = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getMetadataFormat();
        Date fromDate = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getFromDate();
        Date untilDate = ((OaipmhHarvestPluginMetadata)this.getPluginMetadata()).getUntilDate();
        OAIPMHHarvestingDetails oaipmhHarvestingDetails = new OAIPMHHarvestingDetails();
        if (StringUtils.isNotEmpty((CharSequence)metadataFormat)) {
            oaipmhHarvestingDetails.setSchemas(new HashSet<String>(Collections.singletonList(metadataFormat)));
        }
        if (StringUtils.isNotEmpty((CharSequence)setSpec)) {
            oaipmhHarvestingDetails.setSets(new HashSet<String>(Collections.singletonList(setSpec)));
        }
        oaipmhHarvestingDetails.setDateFrom(fromDate);
        oaipmhHarvestingDetails.setDateUntil(untilDate);
        dpsTask.setHarvestingDetails(oaipmhHarvestingDetails);
        return dpsTask;
    }
}

