/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.test.utils;

import eu.europeana.cloud.common.model.dps.ErrorDetails;
import eu.europeana.cloud.common.model.dps.NodeStatistics;
import eu.europeana.cloud.common.model.dps.States;
import eu.europeana.cloud.common.model.dps.StatisticsReport;
import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorInfo;
import eu.europeana.cloud.common.model.dps.TaskErrorsInfo;
import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.core.common.Country;
import eu.europeana.metis.core.common.Language;
import eu.europeana.metis.core.dataset.Dataset;
import eu.europeana.metis.core.dataset.DatasetXslt;
import eu.europeana.metis.core.rest.Record;
import eu.europeana.metis.core.workflow.ScheduleFrequence;
import eu.europeana.metis.core.workflow.ScheduledWorkflow;
import eu.europeana.metis.core.workflow.Workflow;
import eu.europeana.metis.core.workflow.WorkflowExecution;
import eu.europeana.metis.core.workflow.WorkflowStatus;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPlugin;
import eu.europeana.metis.core.workflow.plugins.AbstractMetisPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.EnrichmentPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.LinkCheckingPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.NormalizationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.OaipmhHarvestPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.PluginType;
import eu.europeana.metis.core.workflow.plugins.TransformationPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationExternalPluginMetadata;
import eu.europeana.metis.core.workflow.plugins.ValidationInternalPluginMetadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bson.types.ObjectId;

public class TestObjectFactory {
    public static final int DATASETID = 100;
    public static final String XSLTID = "5a9821af34f04b794dcf63df";
    public static final String EXECUTIONID = "5a5dc67ba458bb00083d49e3";
    public static final String DATASETNAME = "datasetName";
    public static final String WORKFLOWNAME = "workflowName";
    public static final String EMAIL = "user.metis@europeana.eu";
    public static final String AUTHORIZATION_HEADER = "Bearer 1234567890qwertyuiopasdfghjklQWE";
    public static final String TOPOLOGY_NAME = "topology_name";
    public static final long EXTERNAL_TASK_ID = 2070373127078497810L;

    private TestObjectFactory() {
    }

    public static Workflow createWorkflowObject() {
        Workflow workflow = new Workflow();
        workflow.setDatasetId(Integer.toString(100));
        OaipmhHarvestPluginMetadata oaipmhHarvestPluginMetadata = new OaipmhHarvestPluginMetadata();
        oaipmhHarvestPluginMetadata.setUrl("http://example.com");
        oaipmhHarvestPluginMetadata.setEnabled(true);
        ValidationExternalPluginMetadata validationExternalPluginMetadata = new ValidationExternalPluginMetadata();
        validationExternalPluginMetadata.setEnabled(true);
        TransformationPluginMetadata transformationPluginMetadata = new TransformationPluginMetadata();
        transformationPluginMetadata.setEnabled(true);
        ValidationInternalPluginMetadata validationInternalPluginMetadata = new ValidationInternalPluginMetadata();
        validationInternalPluginMetadata.setEnabled(true);
        NormalizationPluginMetadata normalizationPluginMetadata = new NormalizationPluginMetadata();
        normalizationPluginMetadata.setEnabled(true);
        LinkCheckingPluginMetadata linkCheckingPluginMetadata = new LinkCheckingPluginMetadata();
        linkCheckingPluginMetadata.setEnabled(true);
        EnrichmentPluginMetadata enrichmentPluginMetadata = new EnrichmentPluginMetadata();
        enrichmentPluginMetadata.setEnabled(true);
        ArrayList<AbstractMetisPluginMetadata> abstractMetisPluginMetadata = new ArrayList<AbstractMetisPluginMetadata>();
        abstractMetisPluginMetadata.add(oaipmhHarvestPluginMetadata);
        abstractMetisPluginMetadata.add(validationExternalPluginMetadata);
        abstractMetisPluginMetadata.add(transformationPluginMetadata);
        abstractMetisPluginMetadata.add(validationInternalPluginMetadata);
        abstractMetisPluginMetadata.add(normalizationPluginMetadata);
        abstractMetisPluginMetadata.add(linkCheckingPluginMetadata);
        abstractMetisPluginMetadata.add(enrichmentPluginMetadata);
        workflow.setMetisPluginsMetadata(abstractMetisPluginMetadata);
        return workflow;
    }

    public static WorkflowExecution createWorkflowExecutionObject() {
        Dataset dataset = TestObjectFactory.createDataset(DATASETNAME);
        ArrayList<AbstractMetisPlugin> abstractMetisPlugins = new ArrayList<AbstractMetisPlugin>();
        AbstractMetisPlugin oaipmhHarvestPlugin = PluginType.OAIPMH_HARVEST.getNewPlugin(new OaipmhHarvestPluginMetadata());
        abstractMetisPlugins.add(oaipmhHarvestPlugin);
        AbstractMetisPlugin validationExternalPlugin = PluginType.VALIDATION_EXTERNAL.getNewPlugin(new ValidationExternalPluginMetadata());
        abstractMetisPlugins.add(validationExternalPlugin);
        WorkflowExecution workflowExecution = new WorkflowExecution(dataset, abstractMetisPlugins, 0);
        workflowExecution.setWorkflowStatus(WorkflowStatus.INQUEUE);
        workflowExecution.setCreatedDate(new Date());
        return workflowExecution;
    }

    public static WorkflowExecution createWorkflowExecutionObject(Dataset dataset) {
        WorkflowExecution workflowExecution = new WorkflowExecution(dataset, new ArrayList<AbstractMetisPlugin>(), 0);
        workflowExecution.setWorkflowStatus(WorkflowStatus.INQUEUE);
        workflowExecution.setCreatedDate(new Date());
        return workflowExecution;
    }

    public static List<WorkflowExecution> createListOfWorkflowExecutions(int size) {
        ArrayList<WorkflowExecution> workflowExecutions = new ArrayList<WorkflowExecution>(size);
        for (int i = 0; i < size; ++i) {
            Dataset dataset = TestObjectFactory.createDataset(String.format("%s%s", DATASETNAME, i));
            dataset.setDatasetId(Integer.toString(100 + i));
            WorkflowExecution workflowExecution = TestObjectFactory.createWorkflowExecutionObject(dataset);
            workflowExecution.setId(new ObjectId());
            workflowExecutions.add(workflowExecution);
        }
        return workflowExecutions;
    }

    public static void updateListOfWorkflowExecutionsWithWorkflowStatus(List<WorkflowExecution> workflowExecutions, WorkflowStatus workflowStatus) {
        for (WorkflowExecution workflowExecution : workflowExecutions) {
            workflowExecution.setWorkflowStatus(workflowStatus);
        }
    }

    public static ScheduledWorkflow createScheduledWorkflowObject() {
        ScheduledWorkflow scheduledWorkflow = new ScheduledWorkflow();
        scheduledWorkflow.setDatasetId(Integer.toString(100));
        scheduledWorkflow.setPointerDate(new Date());
        scheduledWorkflow.setScheduleFrequence(ScheduleFrequence.ONCE);
        scheduledWorkflow.setWorkflowPriority(0);
        return scheduledWorkflow;
    }

    public static List<ScheduledWorkflow> createListOfScheduledWorkflows(int size) {
        ArrayList<ScheduledWorkflow> scheduledWorkflows = new ArrayList<ScheduledWorkflow>(size);
        for (int i = 0; i < size; ++i) {
            ScheduledWorkflow scheduledWorkflow = TestObjectFactory.createScheduledWorkflowObject();
            scheduledWorkflow.setId(new ObjectId());
            scheduledWorkflow.setDatasetId(Integer.toString(100 + i));
            scheduledWorkflows.add(scheduledWorkflow);
        }
        return scheduledWorkflows;
    }

    public static List<ScheduledWorkflow> createListOfScheduledWorkflowsWithDateAndFrequence(int size, Date date, ScheduleFrequence scheduleFrequence) {
        ArrayList<ScheduledWorkflow> scheduledWorkflows = new ArrayList<ScheduledWorkflow>(size);
        for (int i = 0; i < size; ++i) {
            ScheduledWorkflow scheduledWorkflow = TestObjectFactory.createScheduledWorkflowObject();
            scheduledWorkflow.setId(new ObjectId());
            scheduledWorkflow.setDatasetId(Integer.toString(100 + i));
            scheduledWorkflow.setPointerDate(date);
            scheduledWorkflow.setScheduleFrequence(scheduleFrequence);
            scheduledWorkflows.add(scheduledWorkflow);
        }
        return scheduledWorkflows;
    }

    public static Dataset createDataset(String datasetName) {
        Dataset ds = new Dataset();
        ds.setEcloudDatasetId("NOT_CREATED_YET-f525f64c-fea0-44bf-8c56-88f30962734c");
        ds.setDatasetId(Integer.toString(100));
        ds.setDatasetName(datasetName);
        ds.setOrganizationId("1234567890");
        ds.setOrganizationName("OrganizationName");
        ds.setProvider("1234567890");
        ds.setIntermediateProvider("1234567890");
        ds.setDataProvider("1234567890");
        ds.setCreatedByUserId("userId");
        ds.setCreatedDate(new Date());
        ds.setUpdatedDate(new Date());
        ds.setReplacedBy("replacedBy");
        ds.setReplaces("12345");
        ds.setCountry(Country.GREECE);
        ds.setLanguage(Language.AR);
        ds.setDescription("description");
        ds.setNotes("Notes");
        return ds;
    }

    public static MetisUser createMetisUser(String email) {
        MetisUserAccessToken metisUserAccessToken = new MetisUserAccessToken();
        metisUserAccessToken.setAccessToken("AccessToken_12345");
        metisUserAccessToken.setTimestamp(new Date());
        MetisUser metisUser = new MetisUser();
        metisUser.setEmail(email);
        metisUser.setAccountRole(AccountRole.EUROPEANA_DATA_OFFICER);
        metisUser.setOrganizationId("Organization_12345");
        metisUser.setOrganizationName("OrganizationName");
        metisUser.setMetisUserFlag(true);
        metisUser.setFirstName("FirstName");
        metisUser.setLastName("LastName");
        metisUser.setUserId("User_12345");
        metisUser.setMetisUserAccessToken(metisUserAccessToken);
        return metisUser;
    }

    public static List<SubTaskInfo> createListOfSubTaskInfo() {
        SubTaskInfo subTaskInfo1 = new SubTaskInfo(1, "some_resource_id1", States.SUCCESS, "", "Sensitive Information");
        SubTaskInfo subTaskInfo2 = new SubTaskInfo(2, "some_resource_id1", States.SUCCESS, "", "Sensitive Information");
        ArrayList<SubTaskInfo> subTaskInfos = new ArrayList<SubTaskInfo>();
        subTaskInfos.add(subTaskInfo1);
        subTaskInfos.add(subTaskInfo2);
        return subTaskInfos;
    }

    public static TaskErrorsInfo createTaskErrorsInfoListWithoutIdentifiers(int numberOfErrorTypes) {
        ArrayList<TaskErrorInfo> taskErrorInfos = new ArrayList<TaskErrorInfo>();
        for (int i = 0; i < numberOfErrorTypes; ++i) {
            TaskErrorInfo taskErrorInfo = new TaskErrorInfo("be39ef50-f77d-11e7-af0f-fa163e77119a", String.format("Error%s", i), 2);
            taskErrorInfos.add(taskErrorInfo);
        }
        return new TaskErrorsInfo(2070373127078497810L, taskErrorInfos);
    }

    public static TaskErrorsInfo createTaskErrorsInfoListWithIdentifiers(int numberOfErrorTypes) {
        ArrayList<TaskErrorInfo> taskErrorInfos = new ArrayList<TaskErrorInfo>();
        for (int i = 0; i < numberOfErrorTypes; ++i) {
            TaskErrorInfo taskErrorInfo = new TaskErrorInfo("be39ef50-f77d-11e7-af0f-fa163e77119a", String.format("Error%s", i), 2);
            ArrayList<ErrorDetails> errorDetails = new ArrayList<ErrorDetails>();
            errorDetails.add(new ErrorDetails("identifier1", "error1"));
            errorDetails.add(new ErrorDetails("identifier2", "error2"));
            taskErrorInfo.setErrorDetails(errorDetails);
            taskErrorInfos.add(taskErrorInfo);
        }
        return new TaskErrorsInfo(2070373127078497810L, taskErrorInfos);
    }

    public static TaskErrorsInfo createTaskErrorsInfoWithIdentifiers(String errorType, String message) {
        ArrayList<ErrorDetails> errorDetails = new ArrayList<ErrorDetails>();
        errorDetails.add(new ErrorDetails("identifier1", "error1"));
        errorDetails.add(new ErrorDetails("identifier2", "error2"));
        TaskErrorInfo taskErrorInfo1 = new TaskErrorInfo(errorType, message, 2, errorDetails);
        ArrayList<TaskErrorInfo> taskErrorInfos = new ArrayList<TaskErrorInfo>();
        taskErrorInfos.add(taskErrorInfo1);
        return new TaskErrorsInfo(2070373127078497810L, taskErrorInfos);
    }

    public static StatisticsReport createTaskStatisticsReport() {
        ArrayList<NodeStatistics> nodeStatistics = new ArrayList<NodeStatistics>();
        nodeStatistics.add(new NodeStatistics("parentpath1", "path1", "value1", 1L));
        nodeStatistics.add(new NodeStatistics("parentpath2", "path2", "value2", 2L));
        return new StatisticsReport(2070373127078497810L, nodeStatistics);
    }

    public static DatasetXslt createXslt(Dataset dataset) {
        DatasetXslt datasetXslt = new DatasetXslt(dataset.getDatasetId(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet version=\"2.0\"\nxmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:template match=\"/\">\n<xsl:copy-of select=\"node()\"/>\n</xsl:template>\n</xsl:stylesheet>");
        datasetXslt.setId(new ObjectId());
        return datasetXslt;
    }

    public static List<Record> createListOfRecords(int numberOfRecords) {
        ArrayList<Record> records = new ArrayList<Record>(numberOfRecords);
        for (int i = 0; i < numberOfRecords; ++i) {
            records.add(new Record(UUID.randomUUID().toString(), String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rdf:RDF xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:edm=\"http://www.europeana.eu/schemas/edm/\">\n\t<edm:ProvidedCHO rdf:about=\"http://some.domain.com/id/path/%s\">\n\t</edm:ProvidedCHO>\n</rdf:RDF>\n", i)));
        }
        return records;
    }
}

