/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.core.rest;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import eu.europeana.metis.core.workflow.HasMongoObjectId;
import java.util.List;

public class ResponseListWrapper<T extends HasMongoObjectId> {
    @JacksonXmlElementWrapper(localName="Results")
    @JacksonXmlProperty(localName="Result")
    private List<T> results;
    private int listSize;
    private int nextPage;

    public void setResultsAndLastPage(List<T> results, int resultsPerRequestLimit, int nextPage) {
        if (results != null && !results.isEmpty()) {
            this.nextPage = results.size() < resultsPerRequestLimit ? -1 : nextPage + 1;
            this.listSize = results.size();
        } else {
            this.nextPage = -1;
        }
        this.results = results;
    }

    public void clear() {
        if (this.results != null) {
            this.results.clear();
        }
        this.listSize = 0;
        this.nextPage = 0;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        this.listSize = listSize;
    }
}

