/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.zoho;

import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.crud.ZCRMTrashRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.restclient.ZCRMRestClient;
import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.zoho.ZohoConstants;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZohoAccessClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZohoAccessClient.class);
    private static final int ITEMS_PER_PAGE = 200;
    private final ZCRMModule zcrmModuleContacts;
    private final ZCRMModule zcrmModuleAccounts;

    public ZohoAccessClient() {
        this.zcrmModuleContacts = ZCRMModule.getInstance((String)"Contacts");
        this.zcrmModuleAccounts = ZCRMModule.getInstance((String)"Accounts");
    }

    public ZohoAccessClient(String grantToken) throws ZohoOAuthException {
        try {
            ZCRMRestClient.initialize();
        }
        catch (Exception ex) {
            LOGGER.error("ZCRMRestClient failure!");
            throw new ZohoOAuthException(ex);
        }
        ZohoOAuthClient cli = ZohoOAuthClient.getInstance();
        try {
            cli.generateAccessToken(grantToken);
        }
        catch (ZohoOAuthException e) {
            LOGGER.warn("THIS EXCEPTION IS PROBABLY NORMAL. THAT CAN HAPPEN IF THE GRANT TOKEN HAS BEEN SUCCESSFULLY USED ONCE ALREADY!Exception when generating access token. Grant tokens can be used only once, so when the access and refresh tokens are generated, the grant token becomes obsolete on subsequent deployments", (Throwable)e);
        }
        this.zcrmModuleContacts = ZCRMModule.getInstance((String)"Contacts");
        this.zcrmModuleAccounts = ZCRMModule.getInstance((String)"Accounts");
    }

    public ZCRMRecord getZcrmRecordContactByEmail(String email) throws BadContentException {
        BulkAPIResponse bulkAPIResponseContacts;
        try {
            bulkAPIResponseContacts = this.zcrmModuleContacts.searchByEmail(email);
        }
        catch (ZCRMException e) {
            throw new BadContentException("Zoho search by email threw an exception", e);
        }
        List zcrmRecords = bulkAPIResponseContacts.getData();
        return zcrmRecords.isEmpty() ? null : (ZCRMRecord)zcrmRecords.get(0);
    }

    public ZCRMRecord getZcrmRecordOrganizationByName(String organizationName) throws BadContentException {
        BulkAPIResponse bulkAPIResponseAccounts;
        try {
            bulkAPIResponseAccounts = this.zcrmModuleAccounts.searchByCriteria(String.format("(%s:%s:%s)", "Account_Name", "equals", organizationName));
        }
        catch (ZCRMException e) {
            throw new BadContentException("Zoho search organization by organization name threw an exception", e);
        }
        List zcrmRecords = bulkAPIResponseAccounts.getData();
        return zcrmRecords.isEmpty() ? null : (ZCRMRecord)zcrmRecords.get(0);
    }

    public ZCRMRecord getZcrmRecordOrganizationById(String organizationId) throws BadContentException {
        BulkAPIResponse bulkAPIResponseAccounts;
        try {
            bulkAPIResponseAccounts = this.zcrmModuleAccounts.searchByCriteria(String.format("(%s:%s:%s)", "id", "equals", organizationId));
        }
        catch (ZCRMException e) {
            throw new BadContentException("Zoho search organization by organization id threw an exception", e);
        }
        List zcrmRecords = bulkAPIResponseAccounts.getData();
        return zcrmRecords.isEmpty() ? null : (ZCRMRecord)zcrmRecords.get(0);
    }

    public List<ZCRMTrashRecord> getZCRMTrashRecordDeletedOrganizations(int startPage) throws BadContentException {
        BulkAPIResponse bulkAPIResponseDeletedRecords;
        if (startPage < 1) {
            throw new BadContentException("Invalid start page index. Index must be >= 1", new IllegalArgumentException("start page: " + startPage));
        }
        try {
            bulkAPIResponseDeletedRecords = this.zcrmModuleAccounts.getDeletedRecords(startPage, 200);
        }
        catch (ZCRMException e) {
            throw new BadContentException("Cannot get deleted organization list from: " + startPage, e);
        }
        return bulkAPIResponseDeletedRecords.getData();
    }

    public List<ZCRMRecord> getZcrmRecordOrganizations(int start, int rows, Date modifiedDate) throws BadContentException {
        return this.getZcrmRecordOrganizations(start, rows, modifiedDate, null, null);
    }

    public List<ZCRMRecord> getZcrmRecordOrganizations(int page, int pageSize, Date modifiedDate, Map<String, String> searchCriteria, String criteriaOperator) throws BadContentException {
        BulkAPIResponse bulkAPIResponse;
        if (page < 1 || pageSize < 1) {
            throw new BadContentException("Invalid page or pageSize index. Index must be >= 1", new IllegalArgumentException(String.format("Provided page: %s, and pageSize: %s", page, pageSize)));
        }
        int start = (page - 1) * pageSize + 1;
        String modifiedDateString = null;
        if (modifiedDate != null) {
            modifiedDateString = ZohoConstants.ZOHO_DATE_FORMATTER.format(modifiedDate);
        }
        try {
            bulkAPIResponse = searchCriteria == null || searchCriteria.isEmpty() ? this.zcrmModuleAccounts.getRecords(null, null, null, start, pageSize, modifiedDateString, null, Boolean.FALSE) : this.zcrmModuleAccounts.searchByCriteria(this.createZohoCriteriaString(searchCriteria, criteriaOperator), start, pageSize);
        }
        catch (ZCRMException e) {
            throw new BadContentException("Cannot get organization list from: " + start + " rows :" + pageSize, e);
        }
        return bulkAPIResponse.getData();
    }

    private String createZohoCriteriaString(Map<String, String> searchCriteria, String criteriaOperator) {
        if (searchCriteria == null || searchCriteria.isEmpty()) {
            searchCriteria = new HashMap<String, String>();
        }
        if (criteriaOperator == null || !"equals".equals(criteriaOperator) && !"starts_with".equals(criteriaOperator)) {
            criteriaOperator = "equals";
        }
        String finalCriteriaOperator = criteriaOperator;
        return searchCriteria.entrySet().stream().map(entry -> Arrays.stream(((String)entry.getValue()).split(",")).map(value -> String.format("(%s:%s:%s)", entry.getKey(), finalCriteriaOperator, value.trim())).collect(Collectors.joining("OR"))).collect(Collectors.joining("OR"));
    }
}

