/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipFileReader.class);
    private static final String MAC_TEMP_FOLDER = "__MACOSX";
    private static final String MAC_TEMP_FILE = ".DS_Store";

    public List<String> getRecordsFromZipFile(InputStream providedZipFile) throws IOException {
        try (ZipFile zipFile = this.createTempZipFile(providedZipFile);){
            List<String> list = this.getRecordsFromZipFile(zipFile);
            return list;
        }
    }

    public List<ByteArrayInputStream> getContentFromZipFile(InputStream providedZipFile) throws IOException {
        try (ZipFile zipFile = this.createTempZipFile(providedZipFile);){
            List<InputStream> streams = this.getContentFromZipFile(zipFile);
            ArrayList<ByteArrayInputStream> result = new ArrayList<ByteArrayInputStream>();
            for (InputStream stream : streams) {
                result.add(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)stream)));
            }
            ArrayList<ByteArrayInputStream> arrayList = result;
            return arrayList;
        }
    }

    private ZipFile createTempZipFile(InputStream content) throws IOException {
        String prefix = UUID.randomUUID().toString();
        File tempFile = File.createTempFile(prefix, ".zip");
        FileUtils.copyInputStreamToFile((InputStream)content, (File)tempFile);
        LOGGER.info("Temp file: {} created.", (Object)tempFile);
        return new ZipFile(tempFile, 5);
    }

    List<String> getRecordsFromZipFile(ZipFile zipFile) throws IOException {
        List<InputStream> streams = this.getContentFromZipFile(zipFile);
        ArrayList<String> result = new ArrayList<String>();
        for (InputStream stream : streams) {
            result.add(IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name()));
        }
        return result;
    }

    private List<InputStream> getContentFromZipFile(ZipFile zipFile) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        Iterator entries = zipFile.stream().iterator();
        while (entries.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)entries.next();
            if (!this.accept(zipEntry)) continue;
            result.add(zipFile.getInputStream(zipEntry));
        }
        return result;
    }

    boolean accept(ZipEntry zipEntry) {
        return !zipEntry.isDirectory() && !zipEntry.getName().startsWith(MAC_TEMP_FOLDER) && !zipEntry.getName().endsWith(MAC_TEMP_FILE);
    }
}

