/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.utils;

import java.net.SocketException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRequestUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRequestUtil.class);
    private static final int MAX_RETRIES = 10;
    private static final int SLEEP_TIMEOUT = 500;

    private ExternalRequestUtil() {
    }

    public static <R> R retryableExternalRequestConnectionReset(Supplier<R> supplier) {
        return ExternalRequestUtil.retryableExternalRequestForRuntimeExceptions(supplier, ExternalRequestUtil.getSocketExceptionConnectionReset(), -1, -1);
    }

    public static <R> R retryableExternalRequest(SupplierThrowingException<R> supplierThrowingException, Map<Class<?>, String> exceptionStringMap) throws Exception {
        return ExternalRequestUtil.retryableExternalRequest(supplierThrowingException, exceptionStringMap, -1, -1);
    }

    public static <R> R retryableExternalRequest(SupplierThrowingException<R> supplierThrowingException, Map<Class<?>, String> exceptionStringMap, int maxRetries, int periodBetweenRetriesInMillis) throws Exception {
        maxRetries = maxRetries < 0 ? 10 : maxRetries;
        periodBetweenRetriesInMillis = periodBetweenRetriesInMillis < 0 ? 500 : periodBetweenRetriesInMillis;
        AtomicInteger retriesCounter = new AtomicInteger(0);
        while (true) {
            try {
                return supplierThrowingException.get();
            }
            catch (Exception e) {
                ExternalRequestUtil.doWhenExceptionCaught(e, exceptionStringMap, retriesCounter, maxRetries, periodBetweenRetriesInMillis);
                continue;
            }
            break;
        }
    }

    public static <R> R retryableExternalRequestForRuntimeExceptions(Supplier<R> supplier, Map<Class<?>, String> runtimeExceptionStringMap, int maxRetries, int periodBetweenRetriesInMillis) {
        maxRetries = maxRetries < 0 ? 10 : maxRetries;
        periodBetweenRetriesInMillis = periodBetweenRetriesInMillis < 0 ? 500 : periodBetweenRetriesInMillis;
        AtomicInteger retriesCounter = new AtomicInteger(0);
        while (true) {
            try {
                return supplier.get();
            }
            catch (RuntimeException e) {
                try {
                    ExternalRequestUtil.doWhenExceptionCaught(e, runtimeExceptionStringMap, retriesCounter, maxRetries, periodBetweenRetriesInMillis);
                }
                catch (Exception exception) {
                    throw (RuntimeException)exception;
                }
            }
        }
    }

    private static <R> R doWhenExceptionCaught(Exception e, Map<Class<?>, String> runtimeExceptionStringMap, AtomicInteger retriesCounter, int maxRetries, int periodBetweenRetriesInMillis) throws Exception {
        retriesCounter.incrementAndGet();
        boolean causeMatches = ExternalRequestUtil.doesExceptionCauseMatchAnyOfProvidedExceptions(runtimeExceptionStringMap, e);
        if (retriesCounter.get() > maxRetries || !causeMatches) {
            throw e;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("External request has failed! Retrying in %sms", periodBetweenRetriesInMillis), (Throwable)e);
        }
        try {
            Thread.sleep(periodBetweenRetriesInMillis);
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Thread was interrupted while waiting for retry.", (Throwable)ex);
            Thread.currentThread().interrupt();
            return null;
        }
        return null;
    }

    public static Map<Class<?>, String> getSocketExceptionConnectionReset() {
        return Collections.singletonMap(SocketException.class, "Connection reset");
    }

    public static boolean doesExceptionCauseMatchAnyOfProvidedExceptions(Map<Class<?>, String> runtimeExceptionStringMap, Exception e) {
        Throwable cause = ExternalRequestUtil.getCause(e);
        return runtimeExceptionStringMap.entrySet().stream().anyMatch(entry -> ((Class)entry.getKey()).isInstance(cause) && (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) || cause.getMessage().toLowerCase(Locale.US).contains(((String)entry.getValue()).toLowerCase(Locale.US))));
    }

    private static Throwable getCause(Throwable e) {
        Throwable cause;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    @FunctionalInterface
    public static interface SupplierThrowingException<T> {
        public T get() throws Exception;
    }
}

