/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.solr;

import eu.europeana.metis.utils.InetAddressUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class SolrProperties<E extends Exception> {
    private static final int DEFAULT_ZOOKEEPER_TIMEOUT_IN_SECONDS = 30;
    private final Function<String, E> exceptionCreator;
    private final List<InetSocketAddress> zookeeperHosts = new ArrayList<InetSocketAddress>();
    private String zookeeperChroot;
    private String zookeeperDefaultCollection;
    private Integer zookeeperTimeoutInSecs = 30;
    private final List<URI> solrHosts = new ArrayList<URI>();

    public SolrProperties(Function<String, E> exceptionCreator) {
        this.exceptionCreator = exceptionCreator;
    }

    public void setZookeeperHosts(String[] hosts, int[] ports) throws E {
        List<InetSocketAddress> addresses = new InetAddressUtil<E>(this.exceptionCreator).getAddressesFromHostsAndPorts(this.nonNull(hosts, "hosts"), this.nonNull(ports, "ports"));
        this.zookeeperHosts.clear();
        for (InetSocketAddress address : this.nonNull(addresses, "addresses")) {
            this.addZookeeperHost(address);
        }
    }

    public void addZookeeperHost(InetSocketAddress host) throws E {
        this.zookeeperHosts.add(this.nonNull(host, "host"));
    }

    public void setZookeeperChroot(String chroot) throws E {
        if (StringUtils.isBlank((CharSequence)chroot)) {
            this.zookeeperChroot = null;
        } else if (chroot.charAt(0) == '/') {
            this.zookeeperChroot = chroot;
        } else {
            throw (Exception)this.exceptionCreator.apply("A chroot, if provided, must start with '/'.");
        }
    }

    public void setZookeeperDefaultCollection(String zookeeperDefaultCollection) throws E {
        this.zookeeperDefaultCollection = this.nonNull(zookeeperDefaultCollection, "zookeeperDefaultCollection");
    }

    public void setZookeeperTimeoutInSecs(int zookeeperTimeoutInSecs) {
        this.zookeeperTimeoutInSecs = zookeeperTimeoutInSecs <= 0 ? null : Integer.valueOf(zookeeperTimeoutInSecs);
    }

    public void addSolrHost(URI host) throws E {
        this.solrHosts.add(this.nonNull(host, "host"));
    }

    private <T> T nonNull(T value, String fieldName) throws E {
        if (value == null) {
            throw (Exception)this.exceptionCreator.apply(String.format("Value '%s' cannot be null.", fieldName));
        }
        return value;
    }

    public List<InetSocketAddress> getZookeeperHosts() {
        return Collections.unmodifiableList(this.zookeeperHosts);
    }

    public String getZookeeperChroot() {
        return this.hasZookeeperConnection() ? this.zookeeperChroot : null;
    }

    public String getZookeeperDefaultCollection() throws E {
        if (!this.hasZookeeperConnection()) {
            return null;
        }
        if (this.zookeeperDefaultCollection == null) {
            throw (Exception)this.exceptionCreator.apply("Please provide a Zookeeper default collection name.");
        }
        return this.zookeeperDefaultCollection;
    }

    public Integer getZookeeperTimeoutInSecs() {
        return this.hasZookeeperConnection() ? this.zookeeperTimeoutInSecs : null;
    }

    public List<URI> getSolrHosts() throws E {
        if (this.solrHosts.isEmpty()) {
            throw (Exception)this.exceptionCreator.apply("Please provide at least one Solr host.");
        }
        return Collections.unmodifiableList(this.solrHosts);
    }

    public boolean hasZookeeperConnection() {
        return !this.zookeeperHosts.isEmpty();
    }
}

