/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mongo;

import com.mongodb.MongoClient;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.Morphia;
import dev.morphia.query.Query;
import eu.europeana.metis.mongo.RecordRedirect;
import eu.europeana.metis.utils.ExternalRequestUtil;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordRedirectDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordRedirectDao.class);
    private static final String OLD_ID = "oldId";
    private static final String NEW_ID = "newId";
    private final Datastore datastore;

    public RecordRedirectDao(MongoClient mongoClient, String databaseName) {
        this(mongoClient, databaseName, false);
    }

    public RecordRedirectDao(MongoClient mongoClient, String databaseName, boolean createIndexes) {
        this.datastore = RecordRedirectDao.createDatastore(mongoClient, databaseName);
        if (createIndexes) {
            LOGGER.info("Initializing database indices");
            this.datastore.ensureIndexes();
        }
    }

    private static Datastore createDatastore(MongoClient mongoClient, String databaseName) {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{RecordRedirect.class});
        Datastore datastore = morphia.createDatastore(mongoClient, databaseName);
        LOGGER.info("Datastore initialized");
        return datastore;
    }

    public String createUpdate(RecordRedirect recordRedirect) {
        Key recordRedirectKey = ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> this.datastore.save((Object)recordRedirect));
        LOGGER.debug("RecordRedirect with oldId: '{}', newId: '{}' and timestamp: '{}' created in Mongo", new Object[]{recordRedirect.getOldId(), recordRedirect.getNewId(), recordRedirect.getTimestamp()});
        return recordRedirectKey == null ? null : recordRedirectKey.getId().toString();
    }

    public void delete(RecordRedirect recordRedirect) {
        this.datastore.delete((Object)recordRedirect);
    }

    public RecordRedirect getById(String id) {
        return ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> (RecordRedirect)this.datastore.find(RecordRedirect.class).filter("_id", (Object)new ObjectId(id)).first());
    }

    public List<RecordRedirect> getRecordRedirectsByOldId(String oldId) {
        return this.getRecordRedirects(OLD_ID, oldId);
    }

    public List<RecordRedirect> getRecordRedirectsByNewId(String newId) {
        return this.getRecordRedirects(NEW_ID, newId);
    }

    private List<RecordRedirect> getRecordRedirects(String fieldName, String identifier) {
        return ExternalRequestUtil.retryableExternalRequestConnectionReset(() -> ((Query)this.datastore.find(RecordRedirect.class).field(fieldName).equal((Object)identifier)).find().toList());
    }

    public Datastore getDatastore() {
        return this.datastore;
    }
}

