/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mongo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import eu.europeana.metis.json.ObjectIdSerializer;
import eu.europeana.metis.mongo.HasMongoObjectId;
import java.util.Date;
import org.bson.types.ObjectId;

@Entity
public class RecordRedirect
implements HasMongoObjectId {
    @Id
    @JsonSerialize(using=ObjectIdSerializer.class)
    private ObjectId id;
    @Indexed
    private String newId;
    @Indexed
    private String oldId;
    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date timestamp;

    public RecordRedirect() {
    }

    public RecordRedirect(String newId, String oldId, Date timestamp) {
        this.newId = newId;
        this.oldId = oldId;
        this.timestamp = new Date(timestamp.getTime());
    }

    @Override
    public ObjectId getId() {
        return this.id;
    }

    @Override
    public void setId(ObjectId id) {
        this.id = id;
    }

    public String getNewId() {
        return this.newId;
    }

    public void setNewId(String newId) {
        this.newId = newId;
    }

    public String getOldId() {
        return this.oldId;
    }

    public void setOldId(String oldId) {
        this.oldId = oldId;
    }

    public Date getTimestamp() {
        return this.timestamp == null ? null : new Date(this.timestamp.getTime());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = new Date(timestamp.getTime());
    }
}

