/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mongo;

import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import eu.europeana.metis.utils.InetAddressUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class MongoProperties<E extends Exception> {
    private final Function<String, E> exceptionCreator;
    private final List<ServerAddress> mongoHosts = new ArrayList<ServerAddress>();
    private MongoCredential mongoCredentials;
    private boolean mongoEnableSsl;
    private ReadPreferenceValue readPreferenceValue = ReadPreferenceValue.getDefault();

    public MongoProperties(Function<String, E> exceptionCreator) {
        this.exceptionCreator = exceptionCreator;
    }

    public void setAllProperties(String[] hosts, int[] ports, String authenticationDatabase, String username, String password, boolean enableSsl, ReadPreferenceValue readPreferenceValue) throws E {
        List<ServerAddress> addresses = new InetAddressUtil<E>(this.exceptionCreator).getMongoAddressesFromHostsAndPorts(this.nonNull(hosts, "hosts"), this.nonNull(ports, "ports"));
        this.mongoHosts.clear();
        for (ServerAddress address : this.nonNull(addresses, "addresses")) {
            this.mongoHosts.add(this.nonNull(address, "address"));
        }
        this.mongoCredentials = StringUtils.isBlank((CharSequence)authenticationDatabase) || StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password) ? null : MongoCredential.createCredential((String)username, (String)authenticationDatabase, (char[])password.toCharArray());
        this.mongoEnableSsl = enableSsl;
        this.setReadPreferenceValue(readPreferenceValue);
    }

    public void addMongoHost(InetSocketAddress host) throws E {
        this.mongoHosts.add(new ServerAddress(this.nonNull(host, "host")));
    }

    public void setMongoCredentials(String username, String password, String authenticationDatabase) throws E {
        this.mongoCredentials = MongoCredential.createCredential((String)this.nonNull(username, "username"), (String)this.nonNull(authenticationDatabase, "authenticationDatabase"), (char[])this.nonNull(password, "password").toCharArray());
    }

    public void setMongoEnableSsl() {
        this.mongoEnableSsl = true;
    }

    public void setReadPreferenceValue(ReadPreferenceValue readPreferenceValue) {
        this.readPreferenceValue = Optional.ofNullable(readPreferenceValue).orElse(ReadPreferenceValue.getDefault());
    }

    private <T> T nonNull(T value, String fieldName) throws E {
        if (value == null) {
            throw (Exception)this.exceptionCreator.apply(String.format("Value '%s' cannot be null.", fieldName));
        }
        return value;
    }

    public List<ServerAddress> getMongoHosts() throws E {
        if (this.mongoHosts.isEmpty()) {
            throw (Exception)this.exceptionCreator.apply("Please provide at least one Mongo host.");
        }
        return Collections.unmodifiableList(this.mongoHosts);
    }

    public MongoCredential getMongoCredentials() {
        return this.mongoCredentials;
    }

    public boolean mongoEnableSsl() {
        return this.mongoEnableSsl;
    }

    public ReadPreferenceValue getReadPreferenceValue() {
        return this.readPreferenceValue;
    }

    public static enum ReadPreferenceValue {
        PRIMARY(ReadPreference::primary),
        PRIMARY_PREFERRED(ReadPreference::primaryPreferred),
        SECONDARY(ReadPreference::secondary),
        SECONDARY_PREFERRED(ReadPreference::secondaryPreferred),
        NEAREST(ReadPreference::nearest);

        private Supplier<ReadPreference> readPreferenceSupplier;

        private ReadPreferenceValue(Supplier<ReadPreference> readPreferenceSupplier) {
            this.readPreferenceSupplier = readPreferenceSupplier;
        }

        public Supplier<ReadPreference> getReadPreferenceSupplier() {
            return this.readPreferenceSupplier;
        }

        public static ReadPreferenceValue getDefault() {
            return SECONDARY_PREFERRED;
        }
    }
}

