/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.zoho;

import com.zoho.api.authenticator.OAuthToken;
import com.zoho.api.authenticator.Token;
import com.zoho.api.authenticator.store.TokenStore;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.SDKConfig;
import com.zoho.crm.api.UserSignature;
import com.zoho.crm.api.dc.DataCenter;
import com.zoho.crm.api.dc.USDataCenter;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.record.DeletedRecord;
import com.zoho.crm.api.record.DeletedRecordsHandler;
import com.zoho.crm.api.record.DeletedRecordsWrapper;
import com.zoho.crm.api.record.Record;
import com.zoho.crm.api.record.RecordOperations;
import com.zoho.crm.api.record.ResponseHandler;
import com.zoho.crm.api.record.ResponseWrapper;
import com.zoho.crm.api.util.APIResponse;
import eu.europeana.metis.zoho.ZohoException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class ZohoAccessClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZohoAccessClient.class);
    private static final int ITEMS_PER_PAGE = 200;

    public ZohoAccessClient(TokenStore tokenStore, String zohoEmail, String clientId, String clientSecret, String grandToken, String redirectUrl) {
        try {
            UserSignature userSignature = new UserSignature(zohoEmail);
            OAuthToken token = new OAuthToken(clientId, clientSecret, grandToken, OAuthToken.TokenType.GRANT, redirectUrl);
            SDKConfig sdkConfig = new SDKConfig.Builder().setAutoRefreshFields(false).setPickListValidation(true).build();
            DataCenter.Environment environment = USDataCenter.PRODUCTION;
            String resourcePath = SystemUtils.getUserHome().getAbsolutePath();
            Initializer.initialize((UserSignature)userSignature, (DataCenter.Environment)environment, (Token)token, (TokenStore)tokenStore, (SDKConfig)sdkConfig, (String)resourcePath);
        }
        catch (SDKException e) {
            LOGGER.warn("Exception during initialize", (Throwable)e);
        }
    }

    public Optional<Record> getZohoRecordContactByEmail(String email) throws ZohoException {
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.SearchRecordsParam.EMAIL, (Object)email);
            APIResponse response = recordOperations.searchRecords("Contacts", paramInstance);
            return this.getZohoRecord((APIResponse<ResponseHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Zoho search by email threw an exception", e);
        }
    }

    public Optional<Record> getZohoRecordOrganizationByName(String organizationName) throws ZohoException {
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.SearchRecordsParam.CRITERIA, (Object)String.format("(%s:%s:%s)", "Account_Name", "equals", organizationName));
            APIResponse response = recordOperations.searchRecords("Accounts", paramInstance);
            return this.getZohoRecord((APIResponse<ResponseHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Zoho search organization by organization name threw an exception", e);
        }
    }

    private Optional<Record> getZohoRecord(APIResponse<ResponseHandler> response) {
        return this.getZohoRecords(response).stream().findFirst();
    }

    private List<Record> getZohoRecords(APIResponse<ResponseHandler> response) {
        ResponseHandler responseHandler;
        if (response != null && !this.isEmptyContent(response) && response.isExpected() && (responseHandler = (ResponseHandler)response.getObject()) instanceof ResponseWrapper) {
            ResponseWrapper responseWrapper = (ResponseWrapper)responseHandler;
            return responseWrapper.getData();
        }
        return Collections.emptyList();
    }

    private boolean isEmptyContent(APIResponse<ResponseHandler> response) {
        return Arrays.asList(HttpStatus.NO_CONTENT.value(), HttpStatus.NOT_MODIFIED.value()).contains(response.getStatusCode());
    }

    private List<DeletedRecord> getZohoDeletedRecords(APIResponse<DeletedRecordsHandler> response) {
        DeletedRecordsHandler deletedRecordsHandler;
        if (response != null && response.isExpected() && (deletedRecordsHandler = (DeletedRecordsHandler)response.getObject()) instanceof DeletedRecordsWrapper) {
            DeletedRecordsWrapper deletedRecordsWrapper = (DeletedRecordsWrapper)deletedRecordsHandler;
            return deletedRecordsWrapper.getData();
        }
        return Collections.emptyList();
    }

    public Optional<Record> getZohoRecordOrganizationById(String organizationId) throws ZohoException {
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.SearchRecordsParam.CRITERIA, (Object)String.format("(%s:%s:%s)", "id", "equals", organizationId));
            APIResponse response = recordOperations.searchRecords("Accounts", paramInstance);
            return this.getZohoRecord((APIResponse<ResponseHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Zoho search organization by organization id threw an exception", e);
        }
    }

    public List<DeletedRecord> getZohoDeletedRecordOrganizations(int startPage) throws ZohoException {
        if (startPage < 1) {
            throw new ZohoException("Invalid start page index. Index must be >= 1", new IllegalArgumentException("start page: " + startPage));
        }
        try {
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.TYPE, (Object)"permanent");
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.PAGE, (Object)1);
            paramInstance.add(RecordOperations.GetDeletedRecordsParam.PER_PAGE, (Object)200);
            APIResponse response = recordOperations.getDeletedRecords("Accounts", paramInstance, new HeaderMap());
            return this.getZohoDeletedRecords((APIResponse<DeletedRecordsHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Cannot get deleted organization list from: " + startPage, e);
        }
    }

    public List<Record> getZcrmRecordOrganizations(int start, int rows, OffsetDateTime modifiedDate) throws ZohoException {
        return this.getZcrmRecordOrganizations(start, rows, modifiedDate, null, null);
    }

    public List<Record> getZcrmRecordOrganizations(int page, int pageSize, OffsetDateTime modifiedDate, Map<String, String> searchCriteria, String criteriaOperator) throws ZohoException {
        if (page < 1 || pageSize < 1) {
            throw new ZohoException("Invalid page or pageSize index. Index must be >= 1", new IllegalArgumentException(String.format("Provided page: %s, and pageSize: %s", page, pageSize)));
        }
        try {
            APIResponse response;
            RecordOperations recordOperations = new RecordOperations();
            ParameterMap paramInstance = new ParameterMap();
            if (ZohoAccessClient.isNullOrEmpty(searchCriteria)) {
                paramInstance.add(RecordOperations.GetRecordsParam.PAGE, (Object)page);
                paramInstance.add(RecordOperations.GetRecordsParam.PER_PAGE, (Object)pageSize);
                HeaderMap headerInstance = new HeaderMap();
                headerInstance.add(RecordOperations.GetRecordsHeader.IF_MODIFIED_SINCE, (Object)modifiedDate);
                response = recordOperations.getRecords("Accounts", paramInstance, headerInstance);
            } else {
                paramInstance.add(RecordOperations.SearchRecordsParam.PAGE, (Object)page);
                paramInstance.add(RecordOperations.SearchRecordsParam.PER_PAGE, (Object)pageSize);
                paramInstance.add(RecordOperations.SearchRecordsParam.CRITERIA, (Object)this.createZohoCriteriaString(searchCriteria, criteriaOperator));
                response = recordOperations.searchRecords("Accounts", paramInstance);
            }
            return this.getZohoRecords((APIResponse<ResponseHandler>)response);
        }
        catch (SDKException e) {
            throw new ZohoException("Cannot get organization list page: " + page + " pageSize :" + pageSize, e);
        }
    }

    private String createZohoCriteriaString(Map<String, String> searchCriteria, String criteriaOperator) {
        if (ZohoAccessClient.isNullOrEmpty(searchCriteria)) {
            searchCriteria = new HashMap<String, String>();
        }
        if (Objects.isNull(criteriaOperator) || !"equals".equals(criteriaOperator) && !"starts_with".equals(criteriaOperator)) {
            criteriaOperator = "equals";
        }
        String finalCriteriaOperator = criteriaOperator;
        return searchCriteria.entrySet().stream().map(entry -> Arrays.stream(((String)entry.getValue()).split(",")).map(value -> String.format("(%s:%s:%s)", entry.getKey(), finalCriteriaOperator, value.trim())).collect(Collectors.joining("OR"))).collect(Collectors.joining("OR"));
    }

    private static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }
}

