/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.dao;

import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.authentication.user.MetisUserModel;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PsqlMetisUserDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsqlMetisUserDao.class);
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final int DEFAULT_EXPIRE_TIME_IN_MINS = 10;
    private static final int DEFAULT_PAGE_SIZE_FOR_ACCESS_TOKENS = 100;
    private static final String ACCESS_TOKEN_STRING = "accessToken";
    private static final String EMAIL_STRING = "email";
    private static final String USER_ID_STRING = "user_id";
    private static final String TIMESTAMP_STRING = "timestamp";
    private static final String ACCESS_ROLE_STRING = "accessRole";
    private int accessTokenExpireTimeInMins = 10;
    private final SessionFactory sessionFactory;

    @Autowired
    public PsqlMetisUserDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void createMetisUser(MetisUserModel metisUser) {
        this.createObjectInDB(metisUser);
    }

    public void updateMetisUser(MetisUserModel metisUser) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                session.update((Object)metisUser);
                this.commitTransaction(tx, "Could not update user");
            });
        }
    }

    public MetisUserModel getMetisUserByEmail(String email) {
        return this.getMetisUserByField(EMAIL_STRING, email);
    }

    public MetisUserModel getMetisUserByUserId(String userId) {
        return this.getMetisUserByField(USER_ID_STRING, userId);
    }

    private MetisUserModel getMetisUserByField(String fieldName, String fieldValue) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            MetisUserModel metisUserModel = (MetisUserModel)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                Query query = session.createQuery(String.format("FROM MetisUserModel WHERE %s = :%s", fieldName, fieldName));
                query.setParameter(fieldName, (Object)fieldValue);
                MetisUserModel metisUser = null;
                if (!query.list().isEmpty()) {
                    metisUser = (MetisUserModel)query.list().get(0);
                }
                return metisUser;
            });
            return metisUserModel;
        }
    }

    public MetisUserModel getMetisUserByAccessToken(String accessToken) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            MetisUserModel metisUserModel = (MetisUserModel)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                Query query = session.createQuery(String.format("FROM MetisUserAccessToken WHERE access_token = :%s", ACCESS_TOKEN_STRING));
                query.setParameter(ACCESS_TOKEN_STRING, (Object)accessToken);
                MetisUserAccessToken metisUserAccessToken = null;
                if (!query.list().isEmpty()) {
                    metisUserAccessToken = (MetisUserAccessToken)query.list().get(0);
                }
                MetisUserModel metisUser = null;
                if (metisUserAccessToken != null) {
                    query = session.createQuery(String.format("FROM MetisUserModel WHERE email = :%s", EMAIL_STRING));
                    query.setParameter(EMAIL_STRING, (Object)metisUserAccessToken.getEmail());
                    if (!query.list().isEmpty()) {
                        metisUser = (MetisUserModel)query.list().get(0);
                    }
                }
                return metisUser;
            });
            return metisUserModel;
        }
    }

    public void createUserAccessToken(MetisUserAccessToken metisUserAccessToken) {
        this.createObjectInDB(metisUserAccessToken);
    }

    private void createObjectInDB(Object o) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                session.persist(o);
                this.commitTransaction(tx, "Could not create Object in database.");
            });
        }
    }

    public void expireAccessTokens(Date date) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                List metisUserAccessTokens;
                Transaction tx = session.beginTransaction();
                int offset = 0;
                int pageSize = 100;
                do {
                    CriteriaBuilder builder = session.getCriteriaBuilder();
                    CriteriaQuery criteriaQuery = builder.createQuery(MetisUserAccessToken.class);
                    criteriaQuery.from(MetisUserAccessToken.class);
                    Query query = session.createQuery(criteriaQuery);
                    query.setFirstResult(offset).setMaxResults(pageSize);
                    metisUserAccessTokens = query.getResultList();
                    if (!metisUserAccessTokens.isEmpty()) {
                        this.removeTokensBasedOnExpiryDate(date, (Session)session, metisUserAccessTokens);
                    }
                    offset += pageSize;
                } while (!metisUserAccessTokens.isEmpty());
                this.commitTransaction(tx, "Something when wrong when trying to expire metis authentication tokens");
            });
        }
    }

    private void removeTokensBasedOnExpiryDate(Date date, Session session, List<?> metisUserAccessTokens) {
        for (Object object : metisUserAccessTokens) {
            MetisUserAccessToken metisUserAccessToken = (MetisUserAccessToken)object;
            long accessTokenInMillis = metisUserAccessToken.getTimestamp().getTime();
            Date afterAddingTenMins = new Date(accessTokenInMillis + (long)this.getAccessTokenExpireTimeInMins() * 60000L);
            if (afterAddingTenMins.compareTo(date) > 0) continue;
            Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisUserAccessToken WHERE access_token=:%s", ACCESS_TOKEN_STRING));
            deleteQuery.setParameter(ACCESS_TOKEN_STRING, (Object)metisUserAccessToken.getAccessToken());
            int i = deleteQuery.executeUpdate();
            LOGGER.info("Removed {} Access Token: {}", (Object)i, (Object)metisUserAccessToken.getAccessToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessTokenExpireTimeInMins(int accessTokenExpireTimeInMins) {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            this.accessTokenExpireTimeInMins = accessTokenExpireTimeInMins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessTokenExpireTimeInMins() {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            return this.accessTokenExpireTimeInMins;
        }
    }

    public void deleteMetisUser(String email) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisUserAccessToken WHERE email=:%s", EMAIL_STRING));
                deleteQuery.setParameter(EMAIL_STRING, (Object)email);
                int i = deleteQuery.executeUpdate();
                LOGGER.info("Removed {} Access Token with email: {}", (Object)i, (Object)email);
                deleteQuery = session.createQuery(String.format("DELETE FROM MetisUserModel WHERE email=:%s", EMAIL_STRING));
                deleteQuery.setParameter(EMAIL_STRING, (Object)email);
                i = deleteQuery.executeUpdate();
                LOGGER.info("Removed {} User with email: {}", (Object)i, (Object)email);
                this.commitTransaction(tx, "Could not delete user.");
            });
        }
    }

    public void updateAccessTokenTimestamp(String email) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                Query updateQuery = session.createQuery(String.format("UPDATE MetisUserAccessToken SET timestamp=:%s WHERE email=:%s", TIMESTAMP_STRING, EMAIL_STRING));
                updateQuery.setParameter(TIMESTAMP_STRING, (Object)new Date());
                updateQuery.setParameter(EMAIL_STRING, (Object)email);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} Access Token with email: {}", (Object)itemsUpdated, (Object)email);
                this.commitTransaction(tx, "Could not update authentication access token timestamp.");
            });
        }
    }

    public void updateAccessTokenTimestampByAccessToken(String accessToken) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                Query updateQuery = session.createQuery(String.format("UPDATE MetisUserAccessToken SET timestamp=:%s WHERE access_token=:%s", TIMESTAMP_STRING, ACCESS_TOKEN_STRING));
                updateQuery.setParameter(TIMESTAMP_STRING, (Object)new Date());
                updateQuery.setParameter(ACCESS_TOKEN_STRING, (Object)accessToken);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} Access Token timestamp: {}", (Object)itemsUpdated, (Object)accessToken);
                this.commitTransaction(tx, "Could not update authentication access token timestamp.");
            });
        }
    }

    public void updateMetisUserToMakeAdmin(String userEmailToMakeAdmin) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                Query updateQuery = session.createQuery(String.format("UPDATE MetisUserModel SET account_role=:%s WHERE email=:%s", ACCESS_ROLE_STRING, EMAIL_STRING));
                updateQuery.setParameter(ACCESS_ROLE_STRING, (Object)AccountRole.METIS_ADMIN.name());
                updateQuery.setParameter(EMAIL_STRING, (Object)userEmailToMakeAdmin);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} MetisUserModel with email: {}, made METIS_ADMIN", (Object)itemsUpdated, (Object)userEmailToMakeAdmin);
                this.commitTransaction(tx, "Could not upgrade role of user.");
            });
        }
    }

    private void commitTransaction(Transaction tx, String potentialErrorMessage) {
        try {
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Transaction commit failed with message '{}', rolling back..", (Object)potentialErrorMessage);
            throw new TransactionException(String.format("Transaction commit failed with message '%s'", potentialErrorMessage), (Throwable)e);
        }
    }

    public List<MetisUserModel> getAllMetisUsers() {
        try (Session sessionObject = this.sessionFactory.openSession();){
            List list = (List)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                CriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = builder.createQuery(MetisUserModel.class);
                criteriaQuery.from(MetisUserModel.class);
                Query query = session.createQuery(criteriaQuery);
                return query.getResultList();
            });
            return list;
        }
    }
}

