/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.dao;

import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PsqlMetisUserDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsqlMetisUserDao.class);
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final int DEFAULT_EXPIRE_TIME_IN_MINUTES = 10;
    private static final int DEFAULT_PAGE_SIZE_FOR_ACCESS_TOKENS = 100;
    private static final String ACCESS_TOKEN_STRING = "accessToken";
    private static final String EMAIL_STRING = "email";
    private static final String USER_ID_STRING = "userId";
    private static final String TIMESTAMP_STRING = "timestamp";
    private static final String ACCESS_ROLE_STRING = "accessRole";
    private int accessTokenExpireTimeInMinutes = 10;
    private final SessionFactory sessionFactory;

    @Autowired
    public PsqlMetisUserDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void createMetisUser(MetisUser metisUser) {
        this.createObjectInDB(metisUser);
    }

    public void updateMetisUser(MetisUser metisUser) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                session.merge((Object)metisUser);
                this.commitTransaction(tx, "Could not update user");
            });
        }
    }

    public MetisUser getMetisUserByEmail(String email) {
        return this.getMetisUserByField(EMAIL_STRING, email);
    }

    public MetisUser getMetisUserByUserId(String userId) {
        return this.getMetisUserByField(USER_ID_STRING, userId);
    }

    private MetisUser getMetisUserByField(String fieldName, String fieldValue) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            MetisUser metisUser = (MetisUser)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                String hqlString = String.format("FROM %s WHERE %s = :%s", MetisUser.class.getSimpleName(), fieldName, fieldName);
                SelectionQuery query = session.createSelectionQuery(hqlString, MetisUser.class);
                query.setParameter(fieldName, (Object)fieldValue);
                MetisUser metisUser = null;
                if (!query.list().isEmpty()) {
                    metisUser = (MetisUser)query.list().getFirst();
                }
                return metisUser;
            });
            return metisUser;
        }
    }

    public MetisUser getMetisUserByAccessToken(String accessToken) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            MetisUser metisUser = (MetisUser)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                String hqlMetisUserAccessToken = String.format("FROM %s WHERE accessToken = :%s", MetisUserAccessToken.class.getSimpleName(), ACCESS_TOKEN_STRING);
                SelectionQuery queryMetisUserAccessToken = session.createSelectionQuery(hqlMetisUserAccessToken, MetisUserAccessToken.class);
                queryMetisUserAccessToken.setParameter(ACCESS_TOKEN_STRING, (Object)accessToken);
                MetisUserAccessToken metisUserAccessToken = null;
                if (!queryMetisUserAccessToken.list().isEmpty()) {
                    metisUserAccessToken = (MetisUserAccessToken)queryMetisUserAccessToken.list().getFirst();
                }
                MetisUser metisUser = null;
                if (metisUserAccessToken != null) {
                    String hqlMetisUser = String.format("FROM %s WHERE email = :%s", MetisUser.class.getSimpleName(), EMAIL_STRING);
                    SelectionQuery queryMetisUser = session.createSelectionQuery(hqlMetisUser, MetisUser.class);
                    queryMetisUser.setParameter(EMAIL_STRING, (Object)metisUserAccessToken.getEmail());
                    if (!queryMetisUser.list().isEmpty()) {
                        metisUser = (MetisUser)queryMetisUser.list().getFirst();
                    }
                }
                return metisUser;
            });
            return metisUser;
        }
    }

    public void createUserAccessToken(MetisUserAccessToken metisUserAccessToken) {
        this.createObjectInDB(metisUserAccessToken);
    }

    private void createObjectInDB(Object o) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                session.persist(o);
                this.commitTransaction(tx, "Could not create Object in database.");
            });
        }
    }

    public void expireAccessTokens(Date date) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                List metisUserAccessTokens;
                Transaction tx = session.beginTransaction();
                int offset = 0;
                int pageSize = 100;
                do {
                    HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                    CriteriaQuery criteriaQuery = builder.createQuery(MetisUserAccessToken.class);
                    criteriaQuery.from(MetisUserAccessToken.class);
                    Query query = session.createQuery(criteriaQuery);
                    query.setFirstResult(offset).setMaxResults(pageSize);
                    metisUserAccessTokens = query.getResultList();
                    if (!metisUserAccessTokens.isEmpty()) {
                        this.removeTokensBasedOnExpiryDate(date, (Session)session, metisUserAccessTokens);
                    }
                    offset += pageSize;
                } while (!metisUserAccessTokens.isEmpty());
                this.commitTransaction(tx, "Something when wrong when trying to expire metis authentication tokens");
            });
        }
    }

    private void removeTokensBasedOnExpiryDate(Date date, Session session, List<?> metisUserAccessTokens) {
        for (Object object : metisUserAccessTokens) {
            MetisUserAccessToken metisUserAccessToken = (MetisUserAccessToken)object;
            long accessTokenInMillis = metisUserAccessToken.getTimestamp().getTime();
            Date afterAddingTenMins = new Date(accessTokenInMillis + (long)this.getAccessTokenExpireTimeInMinutes() * 60000L);
            if (afterAddingTenMins.compareTo(date) > 0) continue;
            MutationQuery deleteQuery = session.createMutationQuery(String.format("DELETE FROM %s WHERE accessToken=:%s", MetisUserAccessToken.class.getSimpleName(), ACCESS_TOKEN_STRING));
            deleteQuery.setParameter(ACCESS_TOKEN_STRING, (Object)metisUserAccessToken.getAccessToken());
            int i = deleteQuery.executeUpdate();
            LOGGER.info("Removed {} Access Token: {}", (Object)i, (Object)metisUserAccessToken.getAccessToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessTokenExpireTimeInMinutes(int accessTokenExpireTimeInMinutes) {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            this.accessTokenExpireTimeInMinutes = accessTokenExpireTimeInMinutes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessTokenExpireTimeInMinutes() {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            return this.accessTokenExpireTimeInMinutes;
        }
    }

    public void deleteMetisUser(String email) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                MutationQuery deleteQuery = session.createMutationQuery(String.format("DELETE FROM %s WHERE email=:%s", MetisUserAccessToken.class.getSimpleName(), EMAIL_STRING));
                deleteQuery.setParameter(EMAIL_STRING, (Object)email);
                int i = deleteQuery.executeUpdate();
                LOGGER.info("Removed {} Access Token with email: {}", (Object)i, (Object)email);
                deleteQuery = session.createMutationQuery(String.format("DELETE FROM %s WHERE email=:%s", MetisUser.class.getSimpleName(), EMAIL_STRING));
                deleteQuery.setParameter(EMAIL_STRING, (Object)email);
                i = deleteQuery.executeUpdate();
                LOGGER.info("Removed {} User with email: {}", (Object)i, (Object)email);
                this.commitTransaction(tx, "Could not delete user.");
            });
        }
    }

    public void updateAccessTokenTimestamp(String email) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                MutationQuery updateQuery = session.createMutationQuery(String.format("UPDATE %s SET timestamp=:%s WHERE email=:%s", MetisUserAccessToken.class.getSimpleName(), TIMESTAMP_STRING, EMAIL_STRING));
                updateQuery.setParameter(TIMESTAMP_STRING, (Object)new Date());
                updateQuery.setParameter(EMAIL_STRING, (Object)email);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} Access Token with email: {}", (Object)itemsUpdated, (Object)email);
                this.commitTransaction(tx, "Could not update authentication access token timestamp.");
            });
        }
    }

    public void updateAccessTokenTimestampByAccessToken(String accessToken) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                MutationQuery updateQuery = session.createMutationQuery(String.format("UPDATE %s SET timestamp=:%s WHERE accessToken=:%s", MetisUserAccessToken.class.getSimpleName(), TIMESTAMP_STRING, ACCESS_TOKEN_STRING));
                updateQuery.setParameter(TIMESTAMP_STRING, (Object)new Date());
                updateQuery.setParameter(ACCESS_TOKEN_STRING, (Object)accessToken);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} Access Token timestamp: {}", (Object)itemsUpdated, (Object)accessToken);
                this.commitTransaction(tx, "Could not update authentication access token timestamp.");
            });
        }
    }

    public void updateMetisUserToMakeAdmin(String userEmailToMakeAdmin) {
        try (Session sessionObject = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)sessionObject, session -> {
                Transaction tx = session.beginTransaction();
                MutationQuery updateQuery = session.createMutationQuery(String.format("UPDATE %s SET accountRole=:%s WHERE email=:%s", MetisUser.class.getSimpleName(), ACCESS_ROLE_STRING, EMAIL_STRING));
                updateQuery.setParameter(ACCESS_ROLE_STRING, (Object)AccountRole.METIS_ADMIN.name());
                updateQuery.setParameter(EMAIL_STRING, (Object)userEmailToMakeAdmin);
                int itemsUpdated = updateQuery.executeUpdate();
                LOGGER.info("Updated {} metis user with email: {}, made METIS_ADMIN", (Object)itemsUpdated, (Object)userEmailToMakeAdmin);
                this.commitTransaction(tx, "Could not upgrade role of user.");
            });
        }
    }

    private void commitTransaction(Transaction tx, String potentialErrorMessage) {
        try {
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Transaction commit failed with message '{}', rolling back..", (Object)potentialErrorMessage);
            throw new TransactionException(String.format("Transaction commit failed with message '%s'", potentialErrorMessage), (Throwable)e);
        }
    }

    public List<MetisUser> getAllMetisUsers() {
        try (Session sessionObject = this.sessionFactory.openSession();){
            List list = (List)SonarqubeNullcheckAvoidanceUtils.performFunction((Object)sessionObject, session -> {
                HibernateCriteriaBuilder builder = session.getCriteriaBuilder();
                CriteriaQuery criteriaQuery = builder.createQuery(MetisUser.class);
                criteriaQuery.from(MetisUser.class);
                Query query = session.createQuery(criteriaQuery);
                return query.getResultList();
            });
            return list;
        }
    }
}

