/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.dao;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.metis.common.model.OrganizationRole;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ZohoAccessClientDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZohoAccessClientDao.class);
    private final String zohoBaseUrl;
    private final String zohoAuthenticationToken;

    public ZohoAccessClientDao(String zohoBaseUrl, String zohoAuthenticationToken) {
        this.zohoBaseUrl = zohoBaseUrl;
        this.zohoAuthenticationToken = zohoAuthenticationToken;
    }

    public JsonNode getUserByEmail(String email) throws GenericMetisException {
        String contactsSearchUrl = String.format("%s/%s/%s/%s", this.zohoBaseUrl, "json", "Contacts", "searchRecords");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("authtoken", new Object[]{this.zohoAuthenticationToken}).queryParam("scope", new Object[]{"crmapi"}).queryParam("criteria", new Object[]{String.format("(%s:%s)", "Email", email)});
        RestTemplate restTemplate = new RestTemplate();
        String contactResponse = (String)restTemplate.getForObject(builder.build().encode().toUri(), String.class);
        LOGGER.info(contactResponse);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonContactResponse = null;
        try {
            jsonContactResponse = mapper.readTree(contactResponse);
        }
        catch (IOException e) {
            throw new BadContentException(String.format("Cannot retrieve user with email %s, from Zoho", email), (Throwable)e);
        }
        if (jsonContactResponse.get("response").get("result") == null) {
            return null;
        }
        return jsonContactResponse.get("response").get("result").get("Contacts").get("row").get("FL");
    }

    public String getOrganizationIdByOrganizationName(String organizationName) throws GenericMetisException {
        JsonNode jsonContactResponse;
        String contactsSearchUrl = String.format("%s/%s/%s/%s", this.zohoBaseUrl, "json", "Accounts", "searchRecords");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("authtoken", new Object[]{this.zohoAuthenticationToken}).queryParam("scope", new Object[]{"crmapi"}).queryParam("criteria", new Object[]{String.format("(%s:%s)", "Account Name", organizationName)});
        RestTemplate restTemplate = new RestTemplate();
        String contactResponse = (String)restTemplate.getForObject(builder.build().encode().toUri(), String.class);
        LOGGER.info(contactResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonContactResponse = mapper.readTree(contactResponse);
        }
        catch (IOException e) {
            throw new BadContentException(String.format("Cannot retrieve organization with orgnaization name %s, from Zoho", organizationName), (Throwable)e);
        }
        return this.checkOrganizationRoleAndGetOrganizationIdFromJsonNode(this.findExactMatchOfOrganization(jsonContactResponse, organizationName));
    }

    private JsonNode findExactMatchOfOrganization(JsonNode jsonOrgizationsResponse, String organizationName) {
        if (jsonOrgizationsResponse.get("response").get("result") == null) {
            return null;
        }
        if (jsonOrgizationsResponse.get("response").get("result").get("Accounts").get("row").isArray()) {
            return this.findOrganizationFromListOfJsonNodes(jsonOrgizationsResponse, organizationName);
        }
        return jsonOrgizationsResponse.get("response").get("result").get("Accounts").get("row").get("FL");
    }

    private JsonNode findOrganizationFromListOfJsonNodes(JsonNode jsonOrgizationsResponse, String organizationName) {
        Iterator organizationJsonNodes = jsonOrgizationsResponse.get("response").get("result").get("Accounts").get("row").elements();
        if (organizationJsonNodes == null || !organizationJsonNodes.hasNext()) {
            return null;
        }
        while (organizationJsonNodes.hasNext()) {
            JsonNode nextOrganizationJsonNode = ((JsonNode)organizationJsonNodes.next()).get("FL");
            Iterator organizationFields = nextOrganizationJsonNode.elements();
            while (organizationFields.hasNext()) {
                JsonNode organizationField = (JsonNode)organizationFields.next();
                JsonNode val = organizationField.get("val");
                JsonNode content = organizationField.get("content");
                if (!StringUtils.equals((CharSequence)val.textValue(), (CharSequence)"Account Name") || !StringUtils.equals((CharSequence)content.textValue(), (CharSequence)organizationName)) continue;
                return nextOrganizationJsonNode;
            }
        }
        return null;
    }

    private String checkOrganizationRoleAndGetOrganizationIdFromJsonNode(JsonNode jsonNode) throws BadContentException {
        String organizationId = null;
        if (jsonNode != null) {
            Iterator elements = jsonNode.elements();
            OrganizationRole organizationRole = null;
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                JsonNode val = next.get("val");
                JsonNode content = next.get("content");
                switch (val.textValue()) {
                    case "ACCOUNTID": {
                        organizationId = content.textValue();
                        break;
                    }
                    case "Organisation Role": {
                        organizationRole = OrganizationRole.getRoleFromName((String)content.textValue());
                        break;
                    }
                }
            }
            if (organizationRole == null) {
                throw new BadContentException("Organization Role from Zoho is empty");
            }
        }
        return organizationId;
    }

    private void applyFilters(UriComponentsBuilder builder, Map<String, String> searchCriteria) {
        if (searchCriteria == null || searchCriteria.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : searchCriteria.entrySet()) {
            String[] filterCriteria;
            StringBuilder filterBuilder = new StringBuilder();
            for (String filter : filterCriteria = entry.getValue().split(",")) {
                filterBuilder.append(String.format("(%s:%s)", entry.getKey(), filter.trim()));
                filterBuilder.append("OR");
            }
            filterBuilder.delete(filterBuilder.length() - "OR".length(), filterBuilder.length());
            builder.queryParam("criteria", new Object[]{String.format("(%s)", filterBuilder.toString())});
        }
    }

    public URI buildOrganizationUriById(String organizationId) {
        URI uri = null;
        String contactsSearchUrl = String.format("%s/%s/%s/%s", this.zohoBaseUrl, "json", "Accounts", "getRecords");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("authtoken", new Object[]{this.zohoAuthenticationToken}).queryParam("scope", new Object[]{"crmapi"}).queryParam("id", new Object[]{organizationId});
        uri = builder.build().encode().toUri();
        LOGGER.trace("{}", (Object)uri);
        return uri;
    }

    public JsonNode getOrganizationById(String organizationId) throws GenericMetisException {
        RestTemplate restTemplate = new RestTemplate();
        URI uri = this.buildOrganizationUriById(organizationId);
        String organisationsResponse = (String)restTemplate.getForObject(uri, String.class);
        LOGGER.debug(organisationsResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(organisationsResponse);
        }
        catch (IOException e) {
            throw new GenericMetisException("Cannot parse zoho response: " + organisationsResponse, (Throwable)e);
        }
    }

    public JsonNode getOrganizationFromFile(File contentFile) throws GenericMetisException, IOException {
        String organisationsResponse = FileUtils.readFileToString((File)contentFile, (String)"UTF-8");
        return this.parseZohoResponse(organisationsResponse);
    }

    public JsonNode getOrganizationFromStream(InputStream responseStream) throws GenericMetisException, IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)responseStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        String organisationsResponse = writer.toString();
        return this.parseZohoResponse(organisationsResponse);
    }

    private JsonNode parseZohoResponse(String organisationsResponse) throws GenericMetisException {
        LOGGER.debug("Parsing zoho response: {}", (Object)organisationsResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(organisationsResponse);
        }
        catch (IOException e) {
            throw new GenericMetisException("Cannot parse zoho response: " + organisationsResponse, (Throwable)e);
        }
    }

    public JsonNode getOrganizations(int start, int rows, String lastModifiedTime) throws GenericMetisException {
        String contactsSearchUrl = String.format("%s/%s/%s/%s", this.zohoBaseUrl, "json", "Accounts", "getRecords");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("authtoken", new Object[]{this.zohoAuthenticationToken}).queryParam("scope", new Object[]{"crmapi"}).queryParam("fromIndex", new Object[]{start}).queryParam("toIndex", new Object[]{start + rows - 1}).queryParam("sortColumnString", new Object[]{"Modified Time"}).queryParam("sortOrderString", new Object[]{"asc"});
        if (!StringUtils.isBlank((CharSequence)lastModifiedTime)) {
            builder.queryParam("lastModifiedTime", new Object[]{lastModifiedTime});
        }
        RestTemplate restTemplate = new RestTemplate();
        URI uri = builder.build().encode().toUri();
        LOGGER.trace("{}", (Object)uri);
        String organisationsResponse = (String)restTemplate.getForObject(uri, String.class);
        LOGGER.debug(organisationsResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(organisationsResponse);
        }
        catch (IOException e) {
            throw new GenericMetisException("Cannot parse zoho response: " + organisationsResponse, (Throwable)e);
        }
    }

    public JsonNode searchOrganizations(int start, int rows, String lastModifiedTime, Map<String, String> searchCriteria) throws GenericMetisException {
        String contactsSearchUrl = String.format("%s/%s/%s/%s", this.zohoBaseUrl, "json", "Accounts", "searchRecords");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)contactsSearchUrl).queryParam("authtoken", new Object[]{this.zohoAuthenticationToken}).queryParam("scope", new Object[]{"crmapi"}).queryParam("fromIndex", new Object[]{start}).queryParam("toIndex", new Object[]{start + rows - 1}).queryParam("sortColumnString", new Object[]{"Modified Time"}).queryParam("sortOrderString", new Object[]{"asc"});
        if (!StringUtils.isBlank((CharSequence)lastModifiedTime)) {
            builder.queryParam("lastModifiedTime", new Object[]{lastModifiedTime});
        }
        this.applyFilters(builder, searchCriteria);
        RestTemplate restTemplate = new RestTemplate();
        URI uri = builder.build().encode().toUri();
        LOGGER.trace("{}", (Object)uri);
        String organisationsResponse = (String)restTemplate.getForObject(uri, String.class);
        LOGGER.debug(organisationsResponse);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(organisationsResponse);
        }
        catch (IOException e) {
            throw new GenericMetisException("Cannot parse zoho response: " + organisationsResponse, (Throwable)e);
        }
    }
}

