/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.dao;

import eu.europeana.metis.authentication.user.AccountRole;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PsqlMetisUserDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(PsqlMetisUserDao.class);
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final int DEFAULT_EXPIRE_TIME_IN_MINS = 10;
    private static final int DEFAULT_PAGE_SIZE_FOR_ACCESS_TOKENS = 100;
    private static final String ACCESS_TOKEN_STRING = "accessToken";
    private static final String EMAIL_STRING = "email";
    private static final String USER_ID_STRING = "user_id";
    private static final String TIMESTAMP_STRING = "timestamp";
    private static final String ACCESS_ROLE_STRING = "accessRole";
    private int accessTokenExpireTimeInMins = 10;
    private final SessionFactory sessionFactory;

    @Autowired
    public PsqlMetisUserDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void createMetisUser(MetisUser metisUser) {
        this.createObjectInDB(metisUser);
    }

    public void updateMetisUser(MetisUser metisUser) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        try {
            session.update((Object)metisUser);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Could not persist object, rolling back..");
            throw new TransactionException("Could not persist object in database", (Throwable)e);
        }
        finally {
            session.flush();
            session.close();
        }
    }

    public MetisUser getMetisUserByEmail(String email) {
        return this.getMetisUserByField(EMAIL_STRING, email);
    }

    public MetisUser getMetisUserByUserId(String userId) {
        return this.getMetisUserByField(USER_ID_STRING, userId);
    }

    private MetisUser getMetisUserByField(String fieldName, String fieldValue) {
        Session session = this.sessionFactory.openSession();
        Query query = session.createQuery(String.format("FROM MetisUser WHERE %s = :%s", fieldName, fieldName));
        query.setString(fieldName, fieldValue);
        MetisUser metisUser = null;
        if (!query.list().isEmpty()) {
            metisUser = (MetisUser)query.list().get(0);
        }
        session.flush();
        session.close();
        return metisUser;
    }

    public MetisUser getMetisUserByAccessToken(String accessToken) {
        Session session = this.sessionFactory.openSession();
        Query query = session.createQuery(String.format("FROM MetisUserAccessToken WHERE access_token = :%s", ACCESS_TOKEN_STRING));
        query.setString(ACCESS_TOKEN_STRING, accessToken);
        MetisUserAccessToken metisUserAccessToken = null;
        if (!query.list().isEmpty()) {
            metisUserAccessToken = (MetisUserAccessToken)query.list().get(0);
        }
        MetisUser metisUser = null;
        if (metisUserAccessToken != null) {
            query = session.createQuery(String.format("FROM MetisUser WHERE email = :%s", EMAIL_STRING));
            query.setString(EMAIL_STRING, metisUserAccessToken.getEmail());
            if (!query.list().isEmpty()) {
                metisUser = (MetisUser)query.list().get(0);
            }
        }
        session.flush();
        session.close();
        return metisUser;
    }

    public void createUserAccessToken(MetisUserAccessToken metisUserAccessToken) {
        this.createObjectInDB(metisUserAccessToken);
    }

    private void createObjectInDB(Object o) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        try {
            session.persist(o);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            LOGGER.error("Could not persist object, rolling back..");
            throw new TransactionException("Could not persist object in database", (Throwable)e);
        }
        finally {
            session.flush();
            session.close();
        }
    }

    public void expireAccessTokens(Date date) {
        List metisUserAccessTokens;
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        int offset = 0;
        int pageSize = 100;
        do {
            Criteria criteria;
            if (!(metisUserAccessTokens = (criteria = session.createCriteria(MetisUserAccessToken.class).setFirstResult(offset).setMaxResults(pageSize)).list()).isEmpty()) {
                for (Object object : metisUserAccessTokens) {
                    MetisUserAccessToken metisUserAccessToken = (MetisUserAccessToken)object;
                    long accessTokenInMillis = metisUserAccessToken.getTimestamp().getTime();
                    Date afterAddingTenMins = new Date(accessTokenInMillis + (long)this.getAccessTokenExpireTimeInMins() * 60000L);
                    if (afterAddingTenMins.compareTo(date) > 0) continue;
                    Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisUserAccessToken WHERE access_token=:%s", ACCESS_TOKEN_STRING));
                    deleteQuery.setString(ACCESS_TOKEN_STRING, metisUserAccessToken.getAccessToken());
                    int i = deleteQuery.executeUpdate();
                    LOGGER.info("Removed {} Access Token: {}", (Object)i, (Object)metisUserAccessToken.getAccessToken());
                }
            }
            offset += pageSize;
        } while (!metisUserAccessTokens.isEmpty());
        tx.commit();
        session.flush();
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccessTokenExpireTimeInMins(int accessTokenExpireTimeInMins) {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            this.accessTokenExpireTimeInMins = accessTokenExpireTimeInMins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccessTokenExpireTimeInMins() {
        PsqlMetisUserDao psqlMetisUserDao = this;
        synchronized (psqlMetisUserDao) {
            return this.accessTokenExpireTimeInMins;
        }
    }

    public void deleteMetisUser(String email) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        Query deleteQuery = session.createQuery(String.format("DELETE FROM MetisUserAccessToken WHERE email=:%s", EMAIL_STRING));
        deleteQuery.setString(EMAIL_STRING, email);
        int i = deleteQuery.executeUpdate();
        LOGGER.info("Removed {} Access Token with email: {}", (Object)i, (Object)email);
        deleteQuery = session.createQuery(String.format("DELETE FROM MetisUser WHERE email=:%s", EMAIL_STRING));
        deleteQuery.setString(EMAIL_STRING, email);
        i = deleteQuery.executeUpdate();
        LOGGER.info("Removed {} User with email: {}", (Object)i, (Object)email);
        tx.commit();
        session.flush();
        session.close();
    }

    public void updateAccessTokenTimestamp(String email) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        Query updateQuery = session.createQuery(String.format("UPDATE MetisUserAccessToken SET timestamp=:%s WHERE email=:%s", TIMESTAMP_STRING, EMAIL_STRING));
        updateQuery.setTimestamp(TIMESTAMP_STRING, new Date());
        updateQuery.setString(EMAIL_STRING, email);
        int i = updateQuery.executeUpdate();
        LOGGER.info("Updated {} Access Token with email: {}", (Object)i, (Object)email);
        tx.commit();
        session.flush();
        session.close();
    }

    public void updateAccessTokenTimestampByAccessToken(String accessToken) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        Query updateQuery = session.createQuery(String.format("UPDATE MetisUserAccessToken SET timestamp=:%s WHERE access_token=:%s", TIMESTAMP_STRING, ACCESS_TOKEN_STRING));
        updateQuery.setTimestamp(TIMESTAMP_STRING, new Date());
        updateQuery.setString(ACCESS_TOKEN_STRING, accessToken);
        int i = updateQuery.executeUpdate();
        LOGGER.info("Updated {} Access Token timestamp: {}", (Object)i, (Object)accessToken);
        tx.commit();
        session.flush();
        session.close();
    }

    public void updateMetisUserToMakeAdmin(String userEmailToMakeAdmin) {
        Session session = this.sessionFactory.openSession();
        Transaction tx = session.beginTransaction();
        Query updateQuery = session.createQuery(String.format("UPDATE MetisUser SET account_role=:%s WHERE email=:%s", ACCESS_ROLE_STRING, EMAIL_STRING));
        updateQuery.setString(ACCESS_ROLE_STRING, AccountRole.METIS_ADMIN.name());
        updateQuery.setString(EMAIL_STRING, userEmailToMakeAdmin);
        int i = updateQuery.executeUpdate();
        LOGGER.info("Updated {} MetisUser with email: {}, made METIS_ADMIN", (Object)i, (Object)userEmailToMakeAdmin);
        tx.commit();
        session.flush();
        session.close();
    }

    public List<MetisUser> getAllMetisUsers() {
        Session session = this.sessionFactory.openSession();
        List metisUsersObjects = session.createCriteria(MetisUser.class).list();
        ArrayList<MetisUser> metisUsers = new ArrayList<MetisUser>(metisUsersObjects.size());
        for (Object object : metisUsersObjects) {
            metisUsers.add((MetisUser)object);
        }
        session.flush();
        session.close();
        return metisUsers;
    }
}

