/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.controller.advice;

import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.StructuredExceptionWrapper;
import jakarta.servlet.http.HttpServletResponse;
import org.hibernate.TransactionException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@ControllerAdvice
public class RestResponseExceptionHandler {
    @ExceptionHandler(value={GenericMetisException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleException(Exception ex, HttpServletResponse response) {
        ResponseStatus annotationResponseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        HttpStatus status = annotationResponseStatus == null ? HttpStatus.INTERNAL_SERVER_ERROR : annotationResponseStatus.value();
        response.setStatus(status.value());
        return new StructuredExceptionWrapper(ex.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMessageNotReadable(HttpMessageNotReadableException ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper("Message body not readable. It is missing or malformed\n" + ex.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMissingParams(MissingServletRequestParameterException ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper(ex.getParameterName() + " parameter is missing");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMissingParams(HttpRequestMethodNotSupportedException ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
        return new StructuredExceptionWrapper("Method not allowed: " + ex.getMessage());
    }

    @ExceptionHandler(value={IllegalStateException.class, MethodArgumentTypeMismatchException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMessageNotReadable(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
        return new StructuredExceptionWrapper("Request not readable.\n" + ex.getMessage());
    }

    @ExceptionHandler(value={TransactionException.class})
    @ResponseBody
    public StructuredExceptionWrapper handleMessageTransactionException(Exception ex, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return new StructuredExceptionWrapper(ex.getMessage());
    }
}

