/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.config;

import eu.europeana.metis.authentication.dao.PsqlMetisUserDao;
import eu.europeana.metis.authentication.rest.config.properties.MetisAuthenticationConfigurationProperties;
import eu.europeana.metis.authentication.service.AuthenticationService;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import eu.europeana.metis.utils.apm.ElasticAPMConfiguration;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.List;
import metis.common.config.properties.TruststoreConfigurationProperties;
import metis.common.config.properties.postgres.HibernateConfigurationProperties;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableConfigurationProperties(value={ElasticAPMConfiguration.class, TruststoreConfigurationProperties.class, HibernateConfigurationProperties.class, MetisAuthenticationConfigurationProperties.class})
@ComponentScan(basePackages={"eu.europeana.metis.authentication.rest.controller"})
@EnableScheduling
public class ApplicationConfiguration
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="classpath:create_tables.sql")
    private Resource createTablesSqlResource;
    private SessionFactory sessionFactory;
    private AuthenticationService authenticationService;
    private ApplicationContext applicationContext;

    @Autowired
    public ApplicationConfiguration(TruststoreConfigurationProperties truststoreConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        ApplicationConfiguration.initializeApplication((TruststoreConfigurationProperties)truststoreConfigurationProperties);
    }

    @Bean
    public SessionFactory getSessionFactory(HibernateConfigurationProperties hibernateConfigurationProperties) throws IOException {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        configuration.addAnnotatedClass(MetisUser.class);
        configuration.addAnnotatedClass(MetisUserAccessToken.class);
        configuration.setProperty("hibernate.connection.driver_class", hibernateConfigurationProperties.getConnection().getDriverClass());
        configuration.setProperty("hibernate.connection.url", hibernateConfigurationProperties.getConnection().getUrl());
        configuration.setProperty("hibernate.connection.username", hibernateConfigurationProperties.getConnection().getUsername());
        configuration.setProperty("hibernate.connection.password", hibernateConfigurationProperties.getConnection().getPassword());
        configuration.setProperty("hibernate.c3p0.min_size", hibernateConfigurationProperties.getC3p0().getMinSize());
        configuration.setProperty("hibernate.c3p0.max_size", hibernateConfigurationProperties.getC3p0().getMaxSize());
        configuration.setProperty("hibernate.c3p0.timeout", hibernateConfigurationProperties.getC3p0().getTimeout());
        configuration.setProperty("hibernate.c3p0.max_statements", hibernateConfigurationProperties.getC3p0().getMaxStatements());
        configuration.setProperty("hibernate.hbm2ddl.auto", hibernateConfigurationProperties.getHbm2ddl().getAuto());
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
        this.sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        InputStreamReader reader = new InputStreamReader(this.createTablesSqlResource.getInputStream(), StandardCharsets.UTF_8);
        String createTablesSql = FileCopyUtils.copyToString((Reader)reader);
        try (Session dbSession = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)dbSession, session -> {
                Transaction tx = session.beginTransaction();
                session.createNativeQuery(createTablesSql).executeUpdate();
                tx.commit();
            });
        }
        return this.sessionFactory;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void addCorsMappings(CorsRegistry registry) {
        MetisAuthenticationConfigurationProperties metisAuthenticationConfigurationProperties = (MetisAuthenticationConfigurationProperties)this.applicationContext.getBean(MetisAuthenticationConfigurationProperties.class);
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(metisAuthenticationConfigurationProperties.getAllowedCorsHosts());
    }

    @Bean
    public AuthenticationService getAuthenticationService(PsqlMetisUserDao psqlMetisUserDao) {
        this.authenticationService = new AuthenticationService(psqlMetisUserDao);
        return this.authenticationService;
    }

    @Bean
    public PsqlMetisUserDao getPsqlMetisUserDao(SessionFactory sessionFactory, MetisAuthenticationConfigurationProperties metisAuthenticationConfigurationProperties) {
        PsqlMetisUserDao psqlMetisUserDao = new PsqlMetisUserDao(sessionFactory);
        psqlMetisUserDao.setAccessTokenExpireTimeInMinutes(metisAuthenticationConfigurationProperties.getAccessTokenExpireTimeInMinutes());
        return psqlMetisUserDao;
    }

    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    public void expireAccessTokens() {
        this.authenticationService.expireAccessTokens();
    }

    @PreDestroy
    public void close() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
    }

    static void initializeApplication(TruststoreConfigurationProperties truststoreConfigurationProperties) throws CustomTruststoreAppender.TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPath()) && StringUtils.isNotEmpty((CharSequence)truststoreConfigurationProperties.getPassword())) {
            CustomTruststoreAppender.appendCustomTruststoreToDefault((String)truststoreConfigurationProperties.getPath(), (String)truststoreConfigurationProperties.getPassword());
            LOGGER.info("Custom truststore appended to default truststore");
        }
    }
}

