/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.controller;

import eu.europeana.metis.authentication.service.AuthenticationService;
import eu.europeana.metis.authentication.user.Credentials;
import eu.europeana.metis.authentication.user.EmailParameter;
import eu.europeana.metis.authentication.user.MetisUserView;
import eu.europeana.metis.authentication.user.OldNewPasswordParameters;
import eu.europeana.metis.authentication.user.UserIdParameter;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.UserUnauthorizedException;
import eu.europeana.metis.utils.CommonStringValues;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class AuthenticationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationController.class);
    private static final String ACTION_NOT_ALLOWED_FOR_USER = "Action not allowed";
    private final AuthenticationService authenticationService;

    @Autowired
    public AuthenticationController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/authentication/register"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void registerUser(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        Credentials credentials = this.authenticationService.validateAuthorizationHeaderWithCredentials(authorization);
        this.authenticationService.registerUser(credentials.getEmail(), credentials.getPassword());
        LOGGER.info("User with email {} has been registered", (Object)credentials.getEmail());
    }

    @PostMapping(value={"/authentication/login"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUserView loginUser(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        Credentials credentials = this.authenticationService.validateAuthorizationHeaderWithCredentials(authorization);
        MetisUserView metisUserView = this.authenticationService.loginUser(credentials.getEmail(), credentials.getPassword());
        LOGGER.info("User with email: {} and user id: {} logged in", (Object)metisUserView.getEmail(), (Object)metisUserView.getUserId());
        return metisUserView;
    }

    @PutMapping(value={"/authentication/update/password"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUserPassword(@RequestHeader(value="Authorization") String authorization, @RequestBody OldNewPasswordParameters oldAndNewPasswordParameters) throws GenericMetisException {
        if (oldAndNewPasswordParameters == null || StringUtils.isBlank((CharSequence)oldAndNewPasswordParameters.getOldPassword()) || StringUtils.isBlank((CharSequence)oldAndNewPasswordParameters.getNewPassword())) {
            throw new BadContentException("oldPassword or newPassword not provided");
        }
        if (oldAndNewPasswordParameters.getOldPassword().equals(oldAndNewPasswordParameters.getNewPassword())) {
            throw new BadContentException("newPassword must be different than oldPassword");
        }
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        MetisUserView metisUserView = this.authenticationService.authenticateUser(accessToken);
        this.authenticationService.authenticateUser(metisUserView.getEmail(), oldAndNewPasswordParameters.getOldPassword());
        this.authenticationService.updateUserPassword(metisUserView.getEmail(), oldAndNewPasswordParameters.getNewPassword());
        LOGGER.info("User with access_token: {} updated password", (Object)accessToken);
    }

    @DeleteMapping(value={"/authentication/delete"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@RequestHeader(value="Authorization") String authorization, @RequestBody EmailParameter emailParameter) throws GenericMetisException {
        if (emailParameter == null || StringUtils.isBlank((CharSequence)emailParameter.getEmail())) {
            throw new BadContentException("userEmailToDelete is empty");
        }
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.isUserAdmin(accessToken)) {
            throw new UserUnauthorizedException("Action allowed only from admin users");
        }
        this.authenticationService.deleteUser(emailParameter.getEmail());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} deleted", (Object)CommonStringValues.CRLF_PATTERN.matcher(emailParameter.getEmail()).replaceAll(""));
        }
    }

    @PutMapping(value={"/authentication/update"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUserView updateUser(@RequestHeader(value="Authorization") String authorization, @RequestBody EmailParameter emailParameter) throws GenericMetisException {
        if (emailParameter == null || StringUtils.isBlank((CharSequence)emailParameter.getEmail())) {
            throw new BadContentException("email parameter is empty");
        }
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.hasPermissionToRequestUserUpdate(accessToken, emailParameter.getEmail())) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        MetisUserView metisUserView = this.authenticationService.updateUserFromZoho(emailParameter.getEmail());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} updated", (Object)CommonStringValues.CRLF_PATTERN.matcher(emailParameter.getEmail()).replaceAll(""));
        }
        return metisUserView;
    }

    @PutMapping(value={"/authentication/update/role/admin"}, consumes={"application/json"}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUserToMakeAdmin(@RequestHeader(value="Authorization") String authorization, @RequestBody EmailParameter emailParameter) throws GenericMetisException {
        if (emailParameter == null || StringUtils.isBlank((CharSequence)emailParameter.getEmail())) {
            throw new BadContentException("userEmailToMakeAdmin is empty");
        }
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.isUserAdmin(accessToken)) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        this.authenticationService.updateUserMakeAdmin(emailParameter.getEmail());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} made admin", (Object)CommonStringValues.CRLF_PATTERN.matcher(emailParameter.getEmail()).replaceAll(""));
        }
    }

    @PostMapping(value={"/authentication/user_by_user_id"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUserView getUserByUserId(@RequestHeader(value="Authorization") String authorization, @RequestBody UserIdParameter userIdParameter) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        MetisUserView metisUserView = this.authenticationService.getMetisUserByUserIdOnlyWithPublicFields(accessToken, userIdParameter.getUserId());
        LOGGER.info("User with email: {} and user id: {} found", (Object)metisUserView.getEmail(), (Object)metisUserView.getUserId());
        return metisUserView;
    }

    @GetMapping(value={"/authentication/user_by_access_token"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUserView getUserByAccessToken(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        MetisUserView metisUserView = this.authenticationService.authenticateUser(accessToken);
        LOGGER.info("User with email: {} and user id: {} authenticated", (Object)metisUserView.getEmail(), (Object)metisUserView.getUserId());
        return metisUserView;
    }

    @GetMapping(value={"/authentication/users"}, produces={"application/json", "application/xml"})
    @ResponseBody
    public List<MetisUserView> getAllUsers(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.hasPermissionToRequestAllUsers(accessToken)) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        return this.authenticationService.getAllUsers();
    }
}

