/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.config;

import com.zoho.api.authenticator.store.TokenStore;
import eu.europeana.metis.authentication.dao.PsqlMetisUserDao;
import eu.europeana.metis.authentication.service.AuthenticationService;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.authentication.user.MetisZohoOAuthToken;
import eu.europeana.metis.authentication.utils.MetisZohoOAuthPSQLHandler;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import eu.europeana.metis.utils.SonarqubeNullcheckAvoidanceUtils;
import eu.europeana.metis.utils.apm.ElasticAPMConfiguration;
import eu.europeana.metis.zoho.ZohoAccessClient;
import eu.europeana.metis.zoho.ZohoException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Import(value={ElasticAPMConfiguration.class})
@ComponentScan(basePackages={"eu.europeana.metis.authentication.rest.controller"})
@EnableScheduling
public class ApplicationConfiguration
implements WebMvcConfigurer {
    @Value(value="classpath:create_tables.sql")
    private Resource createTablesSqlResource;
    @Value(value="${truststore.path}")
    private String truststorePath;
    @Value(value="${truststore.password}")
    private String truststorePassword;
    @Value(value="${metis.access.token.expire.time.in.mins}")
    private int metisAccessTokenExpireTimeInMins;
    @Value(value="${allowed.cors.hosts}")
    private String[] allowedCorsHosts;
    @Value(value="${zoho.initial.grant.token}")
    private String zohoInitialGrantToken;
    @Value(value="${zoho.refresh.token}")
    private String zohoRefreshToken;
    @Value(value="${zoho.current.user.email}")
    private String zohoCurrentUserEmail;
    @Value(value="${zoho.client.id}")
    private String zohoClientId;
    @Value(value="${zoho.client.secret}")
    private String zohoClientSecret;
    @Value(value="${zoho.redirect.uri}")
    private String zohoRedirectUri;
    @Value(value="${hibernate.connection.driver_class}")
    private String hibernateConnectionDriverClass;
    @Value(value="${hibernate.connection.url}")
    private String hibernateConnectionUrl;
    @Value(value="${hibernate.dialect}")
    private String hibernateDialect;
    @Value(value="${hibernate.connection.username}")
    private String hibernateConnectionUsername;
    @Value(value="${hibernate.connection.password}")
    private String hibernateConnectionPassword;
    @Value(value="${hibernate.c3p0.min_size}")
    private String hibernateC3P0MinSize;
    @Value(value="${hibernate.c3p0.max_size}")
    private String hibernateC3P0MaxSize;
    @Value(value="${hibernate.c3p0.timeout}")
    private String hibernateC3P0Timeout;
    @Value(value="${hibernate.c3p0.max_statements}")
    private String hibernateC3p0MaxStatements;
    private SessionFactory sessionFactory;
    private AuthenticationService authenticationService;
    private MetisZohoOAuthPSQLHandler metisZohoOAuthPSQLHandler;

    @Bean
    public SessionFactory getSessionFactory() throws CustomTruststoreAppender.TrustStoreConfigurationException, IOException {
        if (StringUtils.isNotEmpty((CharSequence)this.truststorePath) && StringUtils.isNotEmpty((CharSequence)this.truststorePassword)) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)this.truststorePath, (String)this.truststorePassword);
        }
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        configuration.addAnnotatedClass(MetisUser.class);
        configuration.addAnnotatedClass(MetisUserAccessToken.class);
        configuration.addAnnotatedClass(MetisZohoOAuthToken.class);
        configuration.setProperty("hibernate.connection.driver_class", this.hibernateConnectionDriverClass);
        configuration.setProperty("hibernate.connection.url", this.hibernateConnectionUrl);
        configuration.setProperty("hibernate.dialect", this.hibernateDialect);
        configuration.setProperty("hibernate.connection.username", this.hibernateConnectionUsername);
        configuration.setProperty("hibernate.connection.password", this.hibernateConnectionPassword);
        configuration.setProperty("hibernate.c3p0.min_size", this.hibernateC3P0MinSize);
        configuration.setProperty("hibernate.c3p0.max_size", this.hibernateC3P0MaxSize);
        configuration.setProperty("hibernate.c3p0.timeout", this.hibernateC3P0Timeout);
        configuration.setProperty("hibernate.c3p0.max_statements", this.hibernateC3p0MaxStatements);
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        this.sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        InputStreamReader reader = new InputStreamReader(this.createTablesSqlResource.getInputStream(), StandardCharsets.UTF_8);
        String createTablesSql = FileCopyUtils.copyToString((Reader)reader);
        try (Session dbSession = this.sessionFactory.openSession();){
            SonarqubeNullcheckAvoidanceUtils.performAction((Object)dbSession, session -> {
                Transaction tx = session.beginTransaction();
                session.createSQLQuery(createTablesSql).executeUpdate();
                tx.commit();
            });
        }
        return this.sessionFactory;
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(this.allowedCorsHosts);
    }

    @Bean
    public AuthenticationService getAuthenticationService(PsqlMetisUserDao psqlMetisUserDao, ZohoAccessClient zohoAccessClient) {
        this.authenticationService = new AuthenticationService(psqlMetisUserDao, zohoAccessClient);
        return this.authenticationService;
    }

    @Bean
    public ZohoAccessClient getZohoAccessClient(SessionFactory sessionFactory) throws ZohoException {
        this.metisZohoOAuthPSQLHandler = new MetisZohoOAuthPSQLHandler(sessionFactory, this.zohoCurrentUserEmail, this.zohoRefreshToken, this.zohoClientId, this.zohoClientSecret);
        ZohoAccessClient zohoAccessClient = new ZohoAccessClient((TokenStore)this.metisZohoOAuthPSQLHandler, this.zohoCurrentUserEmail, this.zohoClientId, this.zohoClientSecret, this.zohoInitialGrantToken, this.zohoRedirectUri);
        zohoAccessClient.getZohoRecordContactByEmail("");
        return zohoAccessClient;
    }

    @Bean
    public PsqlMetisUserDao getPsqlMetisUserDao(SessionFactory sessionFactory) {
        PsqlMetisUserDao psqlMetisUserDao = new PsqlMetisUserDao(sessionFactory);
        psqlMetisUserDao.setAccessTokenExpireTimeInMins(this.metisAccessTokenExpireTimeInMins);
        return psqlMetisUserDao;
    }

    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    public void expireAccessTokens() {
        this.authenticationService.expireAccessTokens();
    }

    @PreDestroy
    public void close() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
        }
        if (this.metisZohoOAuthPSQLHandler != null) {
            this.metisZohoOAuthPSQLHandler.close();
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
    }
}

