/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.config;

import eu.europeana.metis.authentication.dao.PsqlMetisUserDao;
import eu.europeana.metis.authentication.dao.ZohoAccessClientDao;
import eu.europeana.metis.authentication.service.AuthenticationService;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.authentication.user.MetisUserAccessToken;
import eu.europeana.metis.utils.CustomTruststoreAppender;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.net.ssl.TrustStoreConfigurationException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan(basePackages={"eu.europeana.metis.authentication.rest"})
@PropertySource(value={"classpath:authentication.properties"})
@EnableWebMvc
@EnableScheduling
public class Application
extends WebMvcConfigurerAdapter
implements InitializingBean {
    @Value(value="${truststore.path}")
    private String truststorePath;
    @Value(value="${truststore.password}")
    private String truststorePassword;
    @Value(value="${zoho.base.url}")
    private String zohoBaseUrl;
    @Value(value="${zoho.authentication.token}")
    private String zohoAuthenticationToken;
    @Value(value="${access.token.expire.time.in.mins}")
    private int accessTokenExpireTimeInMins;
    @Value(value="${allowed.cors.hosts}")
    private String[] allowedCorsHosts;
    private SessionFactory sessionFactory;
    private AuthenticationService authenticationService;

    public void afterPropertiesSet() throws TrustStoreConfigurationException {
        if (StringUtils.isNotEmpty((CharSequence)this.truststorePath) && StringUtils.isNotEmpty((CharSequence)this.truststorePassword)) {
            CustomTruststoreAppender.appendCustomTrustoreToDefault((String)this.truststorePath, (String)this.truststorePassword);
        }
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedMethods(new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"}).allowedOrigins(this.allowedCorsHosts);
    }

    @Bean
    public AuthenticationService getAuthenticationService(ZohoAccessClientDao zohoAccessClientDao, PsqlMetisUserDao psqlMetisUserDao) {
        this.authenticationService = new AuthenticationService(zohoAccessClientDao, psqlMetisUserDao);
        return this.authenticationService;
    }

    @Bean
    public ZohoAccessClientDao getZohoAccessClientDao() {
        return new ZohoAccessClientDao(this.zohoBaseUrl, this.zohoAuthenticationToken);
    }

    @Bean
    public SessionFactory getSessionFactory() {
        org.hibernate.cfg.Configuration configuration = new org.hibernate.cfg.Configuration();
        configuration.addAnnotatedClass(MetisUser.class);
        configuration.addAnnotatedClass(MetisUserAccessToken.class);
        configuration.configure();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)configuration.getProperties()).build();
        this.sessionFactory = configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        return this.sessionFactory;
    }

    @Bean
    public PsqlMetisUserDao getPsqlMetisUserDao(SessionFactory sessionFactory) {
        PsqlMetisUserDao psqlMetisUserDao = new PsqlMetisUserDao(sessionFactory);
        psqlMetisUserDao.setAccessTokenExpireTimeInMins(this.accessTokenExpireTimeInMins);
        return psqlMetisUserDao;
    }

    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    public void expireAccessTokens() {
        this.authenticationService.expireAccessTokens();
    }

    @PreDestroy
    public void close() {
        if (this.sessionFactory != null && !this.sessionFactory.isClosed()) {
            this.sessionFactory.close();
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new MappingJackson2XmlHttpMessageConverter());
        super.configureMessageConverters(converters);
    }
}

