/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest;

import eu.europeana.metis.authentication.service.AuthenticationService;
import eu.europeana.metis.authentication.user.Credentials;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.exception.BadContentException;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.UserUnauthorizedException;
import java.util.List;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class AuthenticationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationController.class);
    private static final String ACTION_NOT_ALLOWED_FOR_USER = "Action not allowed";
    private final AuthenticationService authenticationService;

    @Autowired
    public AuthenticationController(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @RequestMapping(value={"/authentication/register"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void registerUser(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        Credentials credentials = this.authenticationService.validateAuthorizationHeaderWithCredentials(authorization);
        this.authenticationService.registerUser(credentials.getEmail(), credentials.getPassword());
        LOGGER.info("User with email {} has been registered", (Object)credentials.getEmail());
    }

    @RequestMapping(value={"/authentication/login"}, method={RequestMethod.POST}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUser loginUser(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        Credentials credentials = this.authenticationService.validateAuthorizationHeaderWithCredentials(authorization);
        MetisUser metisUser = this.authenticationService.loginUser(credentials.getEmail(), credentials.getPassword());
        LOGGER.info("User with email: {} and user id: {} logged in", (Object)metisUser.getEmail(), (Object)metisUser.getUserId());
        return metisUser;
    }

    @RequestMapping(value={"/authentication/update/password"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUserPassword(@RequestHeader(value="Authorization") String authorization, @QueryParam(value="oldPassword") String oldPassword, @QueryParam(value="newPassword") String newPassword) throws GenericMetisException {
        if (StringUtils.isBlank((CharSequence)oldPassword) || StringUtils.isBlank((CharSequence)newPassword)) {
            throw new BadContentException("oldPassword or newPassword not provided");
        }
        if (oldPassword.equals(newPassword)) {
            throw new BadContentException("newPassword must be different than oldPassword");
        }
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        MetisUser metisUser = this.authenticationService.authenticateUser(accessToken);
        this.authenticationService.authenticateUser(metisUser.getEmail(), oldPassword);
        this.authenticationService.updateUserPassword(metisUser, newPassword);
        LOGGER.info("User with access_token: {} updated password", (Object)accessToken);
    }

    @RequestMapping(value={"/authentication/delete"}, method={RequestMethod.DELETE}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteUser(@RequestHeader(value="Authorization") String authorization, @QueryParam(value="userEmailToDelete") String userEmailToDelete) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.isUserAdmin(accessToken)) {
            throw new UserUnauthorizedException("Action allowed only from admin users");
        }
        this.authenticationService.deleteUser(userEmailToDelete);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} deleted", (Object)userEmailToDelete.replaceAll("[\r\n]", ""));
        }
    }

    @RequestMapping(value={"/authentication/update"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUser updateUser(@RequestHeader(value="Authorization") String authorization, @QueryParam(value="userEmailToUpdate") String userEmailToUpdate) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.hasPermissionToRequestUserUpdate(accessToken, userEmailToUpdate)) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        MetisUser metisUser = this.authenticationService.updateUserFromZoho(userEmailToUpdate);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} updated", (Object)userEmailToUpdate.replaceAll("[\r\n]", ""));
        }
        return metisUser;
    }

    @RequestMapping(value={"/authentication/update/role/admin"}, method={RequestMethod.PUT}, produces={"application/json", "application/xml"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateUserToMakeAdmin(@RequestHeader(value="Authorization") String authorization, @QueryParam(value="userEmailToMakeAdmin") String userEmailToMakeAdmin) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.isUserAdmin(accessToken)) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        this.authenticationService.updateUserMakeAdmin(userEmailToMakeAdmin);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("User with email: {} made admin", (Object)userEmailToMakeAdmin.replaceAll("[\r\n]", ""));
        }
    }

    @RequestMapping(value={"/authentication/user_by_access_token"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public MetisUser getUserByAccessToken(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        MetisUser metisUser = this.authenticationService.authenticateUser(accessToken);
        LOGGER.info("User with email: {} and user id: {} authenticated", (Object)metisUser.getEmail(), (Object)metisUser.getUserId());
        return metisUser;
    }

    @RequestMapping(value={"/authentication/users"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public List<MetisUser> getAllUsers(@RequestHeader(value="Authorization") String authorization) throws GenericMetisException {
        String accessToken = this.authenticationService.validateAuthorizationHeaderWithAccessToken(authorization);
        if (!this.authenticationService.hasPermissionToRequestAllUsers(accessToken)) {
            throw new UserUnauthorizedException(ACTION_NOT_ALLOWED_FOR_USER);
        }
        return this.authenticationService.getAllUsers(accessToken);
    }
}

