/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.authentication.rest.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.metis.authentication.user.MetisUser;
import eu.europeana.metis.exception.GenericMetisException;
import eu.europeana.metis.exception.UserUnauthorizedException;
import eu.europeana.metis.network.ExternalRequestUtil;
import java.io.IOException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class AuthenticationClient {
    private final String baseUrl;

    public AuthenticationClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public MetisUser getUserByAccessTokenInHeader(String authorizationHeader) throws GenericMetisException {
        RestTemplate restTemplate = new RestTemplate();
        ObjectMapper objectMapper = new ObjectMapper();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept", "application/json");
        headers.add("Authorization", authorizationHeader);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = (ResponseEntity)ExternalRequestUtil.retryableExternalRequestForNetworkExceptions(() -> restTemplate.exchange(String.format("%s%s", this.baseUrl, "/authentication/user_by_access_token"), HttpMethod.GET, request, String.class, new Object[0]));
            return (MetisUser)objectMapper.readValue(response == null ? null : (String)response.getBody(), MetisUser.class);
        }
        catch (HttpClientErrorException e) {
            throw new UserUnauthorizedException("Wrong access token", (Throwable)e);
        }
        catch (IOException e) {
            throw new UserUnauthorizedException("Could not parse response to Object, {}", (Throwable)e);
        }
    }
}

